/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.util.style;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CSSFormat {
    private Map properties;

    public CSSFormat() {
        this.properties = new HashMap();
    }

    public CSSFormat(String property, String value) {
        this.properties = new HashMap(3);
        this.add(property, value);
    }

    public static String url(String url) {
        StringBuffer buf = new StringBuffer(url.length() + 7);
        buf.append("url(").append(url.replaceAll("([\\)\\(\\s,'\"])", "\\\\$1")).append(")");
        return buf.toString();
    }

    public static String propertyValue(String property, String value) {
        return CSSFormat.formatPropertyValue(property, value);
    }

    private static String formatPropertyValue(Object property, Object value) {
        StringBuffer buf = new StringBuffer();
        buf.append(property).append(": ").append(value).append(";");
        return buf.toString();
    }

    public CSSFormat add(String property, String value) {
        this.properties.put(property, value);
        return this;
    }

    public CSSFormat addURL(String property, String url) {
        this.properties.put(property, CSSFormat.url(url));
        return this;
    }

    public String toString() {
        return this.concatenate(null);
    }

    public String concatenate(String separator) {
        StringBuffer output = new StringBuffer();
        Iterator iter = this.properties.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            output.append(CSSFormat.formatPropertyValue(entry.getKey(), entry.getValue()));
            if (separator == null || !iter.hasNext()) continue;
            output.append(separator);
        }
        return output.toString();
    }
}

