/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.util.style;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Arrays;
import java.util.StringTokenizer;

public final class FontFamily {
    public static final String CSS_MONOSPACED = "MONOSPACE";
    public static final String CSS_SANS_SERIF = "SANS-SERIF";
    public static final String JAVA_MONOSPACED = "MONOSPACED";
    public static final String JAVA_SANS_SERIF = "SANSSERIF";
    private static final String[] FONT_FAMILIES = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();

    private FontFamily() {
    }

    public static Font getFont(String fontFamily, int style, int size) {
        String fontUsed = null;
        StringTokenizer tokenizer = new StringTokenizer(fontFamily, ",");
        while (tokenizer.hasMoreElements()) {
            String fontName = tokenizer.nextToken().trim().toUpperCase();
            if (fontName.equals(CSS_SANS_SERIF)) {
                fontName = JAVA_SANS_SERIF;
            } else if (fontName.equals(CSS_MONOSPACED)) {
                fontName = JAVA_MONOSPACED;
            }
            if (Arrays.binarySearch(FONT_FAMILIES, fontName) < 0) continue;
            fontUsed = fontName;
        }
        if (fontUsed == null) {
            fontUsed = JAVA_SANS_SERIF;
        }
        Font f = new Font(fontUsed, style, size);
        return f;
    }

    static {
        for (int i = 0; i < FONT_FAMILIES.length; ++i) {
            FontFamily.FONT_FAMILIES[i] = FONT_FAMILIES[i].toUpperCase();
        }
        Arrays.sort(FONT_FAMILIES);
    }
}

