/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.webapp;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.ajax4jsf.io.FastBufferOutputStream;
import org.ajax4jsf.io.FastBufferWriter;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.util.Util;
import org.slf4j.Logger;

public class CacheContent
implements Serializable {
    private static final long serialVersionUID = 8120940486890871177L;
    private static final Logger LOG = RichfacesLogger.WEBAPP.getLogger();
    boolean filledOutputWriter = false;
    boolean filledOutputStream = false;
    private byte[] content = null;
    private String writerContent = null;
    private Map<String, Object> headers = new HashMap<String, Object>();
    private Integer contentLength;
    private String contentType;
    private transient FastBufferOutputStream outputStream;
    private transient ServletOutputStream servletStream;
    private transient PrintWriter servletWriter;
    private transient FastBufferWriter stringOutputWriter;

    @Deprecated
    public void send(HttpServletResponse response) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void send(ExternalContext externalContext) throws IOException {
        if (this.filledOutputStream) {
            OutputStream out = externalContext.getResponseOutputStream();
            if (this.content != null) {
                out.write(this.content);
            } else {
                this.outputStream.writeTo(out);
            }
        } else if (this.filledOutputWriter) {
            Writer out = externalContext.getResponseOutputWriter();
            if (null != this.writerContent) {
                out.write(this.writerContent);
            } else {
                this.stringOutputWriter.writeTo(out);
            }
        }
    }

    public void sendHeaders(ExternalContext externalContext) {
        int realContentLength = 0;
        if (this.filledOutputStream) {
            if (null != this.content && this.content.length > 0) {
                realContentLength = this.content.length;
            } else if (null != this.outputStream && this.outputStream.getLength() > 0) {
                realContentLength = this.outputStream.getLength();
            }
        }
        if (realContentLength <= 0 && this.contentLength != null) {
            realContentLength = this.contentLength;
        }
        for (Map.Entry<String, Object> element : this.headers.entrySet()) {
            String header = element.getKey();
            Object headerValue = element.getValue();
            try {
                if (headerValue instanceof Long) {
                    Long time = (Long)headerValue;
                    String formattedDate = Util.formatHttpDate(time);
                    externalContext.setResponseHeader(header, formattedDate);
                } else if (headerValue instanceof Integer) {
                    Integer value = (Integer)headerValue;
                    if ("Content-Length".equals(header)) {
                        if (realContentLength <= 0) {
                            realContentLength = value;
                        }
                    } else {
                        externalContext.setResponseHeader(header, value.toString());
                    }
                } else if (realContentLength <= 0 || !"Transfer-Encoding".equals(header) || !"chunked".equals(headerValue)) {
                    externalContext.setResponseHeader(header, (String)headerValue);
                }
            }
            catch (Exception e) {
                LOG.error("Error set response header " + header + "for value " + headerValue, (Throwable)e);
            }
            if (realContentLength > 0) {
                externalContext.setResponseContentLength(realContentLength);
            }
            if (null == this.contentType) continue;
            externalContext.setResponseContentType(this.contentType);
        }
    }

    @Deprecated
    public void sendHeaders(HttpServletResponse response) {
        throw new UnsupportedOperationException();
    }

    public void setDateHeader(String name, long value) {
        if (!"Expires".equals(name)) {
            this.headers.put(name, new Long(value));
        }
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void setIntHeader(String name, int value) {
        this.headers.put(name, new Integer(value));
    }

    public OutputStream getOutputStream() {
        if (null == this.servletStream) {
            this.outputStream = new FastBufferOutputStream(1024);
            this.servletStream = new ServletOutputStream(){

                public void close() {
                    CacheContent.this.filledOutputStream = true;
                    CacheContent.access$002(CacheContent.this, null);
                }

                public void flush() {
                }

                public void write(byte[] b, int off, int len) throws IOException {
                    CacheContent.this.outputStream.write(b, off, len);
                }

                public void write(byte[] b) throws IOException {
                    CacheContent.this.outputStream.write(b);
                }

                public void write(int b) throws IOException {
                    CacheContent.this.outputStream.write(b);
                }
            };
        }
        return this.servletStream;
    }

    public PrintWriter getWriter() {
        if (null == this.servletWriter) {
            this.stringOutputWriter = new FastBufferWriter(1024);
            Writer out = new Writer(){

                public void write(char[] cbuf, int off, int len) throws IOException {
                    CacheContent.this.stringOutputWriter.write(cbuf, off, len);
                }

                public void flush() throws IOException {
                }

                public void close() throws IOException {
                    CacheContent.this.filledOutputWriter = true;
                    CacheContent.this.writerContent = null;
                }
            };
            this.servletWriter = new PrintWriter(out);
        }
        return this.servletWriter;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        if (this.filledOutputStream) {
            if (this.outputStream != null) {
                this.content = this.outputStream.toByteArray();
            }
        } else if (this.filledOutputWriter && this.stringOutputWriter != null) {
            char[] cs = this.stringOutputWriter.toCharArray();
            this.writerContent = new String(cs);
        }
        s.defaultWriteObject();
    }

    @Deprecated
    public void flush(HttpServletResponse response) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void flush(ExternalContext externalContext) throws IOException {
        if (this.filledOutputStream) {
            OutputStream out = externalContext.getResponseOutputStream();
            out.flush();
        } else if (this.filledOutputWriter) {
            Writer out = externalContext.getResponseOutputWriter();
            out.flush();
        }
    }

    public int getContentLength() {
        if (this.contentLength == null) {
            throw new IllegalStateException("Content length hasn't been set yet!");
        }
        return this.contentLength;
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    static /* synthetic */ byte[] access$002(CacheContent x0, byte[] x1) {
        x0.content = x1;
        return x1;
    }
}

