/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.text.MessageFormat;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipInputStream;
import org.richfaces.log.RichfacesLogger;
import org.slf4j.Logger;

public final class VersionBean {
    private static final Logger LOGGER = RichfacesLogger.APPLICATION.getLogger();
    public static final Version VERSION = new Version();

    public String getVendor() {
        return VERSION.getImplementationVendor();
    }

    public String getTitle() {
        return VERSION.getImplementationTitle();
    }

    public String getRevision() {
        return VERSION.getScmRevision();
    }

    public String getTimestamp() {
        return VERSION.getScmTimestamp();
    }

    public Version getVersion() {
        return VERSION;
    }

    public String toString() {
        if (VERSION.containsDataFromManifest()) {
            return this.getTitle() + " by " + this.getVendor() + ", version " + VERSION.toString();
        }
        return VERSION.toString();
    }

    public static class Version {
        private static final String UNKNOWN = "";
        private String implementationVendor = "";
        private String implementationVersion = "4.0.0-SNAPSHOT";
        private String implementationTitle = "";
        private String scmRevision = "";
        private String scmTimestamp = "";
        private String fullVersionString = "";
        private String resourceVersion = "";
        private boolean containsDataFromManifest = false;

        public Version() {
            this.initialize();
        }

        private String getAttributeValueOrDefault(Attributes attributes, String name) {
            String value = attributes.getValue(name);
            if (value == null) {
                value = UNKNOWN;
            }
            return value;
        }

        private void initialize() {
            Manifest manifest = null;
            try {
                manifest = this.readManifest();
            }
            catch (Exception e) {
                LOGGER.error(MessageFormat.format("Error reading project metadata: {0}", e.getMessage()), (Throwable)e);
            }
            if (manifest != null) {
                this.initializePropertiesFromManifest(manifest);
                this.initializeDerivativeProperties();
            }
        }

        private void initializePropertiesFromManifest(Manifest manifest) {
            this.containsDataFromManifest = true;
            Attributes attributes = manifest.getMainAttributes();
            this.implementationVendor = this.getAttributeValueOrDefault(attributes, "Implementation-Vendor");
            this.implementationVersion = this.getAttributeValueOrDefault(attributes, "Implementation-Version");
            this.implementationTitle = this.getAttributeValueOrDefault(attributes, "Implementation-Title");
            this.scmRevision = this.getAttributeValueOrDefault(attributes, "SCM-Revision");
            this.scmTimestamp = this.getAttributeValueOrDefault(attributes, "SCM-Timestamp");
        }

        private void initializeDerivativeProperties() {
            this.fullVersionString = MessageFormat.format("v.{0} SVN r.{1}", this.implementationVersion, this.scmRevision);
            this.resourceVersion = this.implementationVersion.replace('.', '_') + "_" + this.scmRevision;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Manifest readManifest() {
            URLConnection urlConnection;
            ZipInputStream jis;
            block13: {
                URL url;
                CodeSource codeSource;
                ProtectionDomain domain = VersionBean.class.getProtectionDomain();
                if (domain == null || (codeSource = domain.getCodeSource()) == null || (url = codeSource.getLocation()) == null) return null;
                jis = null;
                urlConnection = url.openConnection();
                urlConnection.setUseCaches(false);
                if (!(urlConnection instanceof JarURLConnection)) break block13;
                JarURLConnection jarUrlConnection = (JarURLConnection)urlConnection;
                Manifest manifest = jarUrlConnection.getManifest();
                if (jis == null) return manifest;
                try {
                    jis.close();
                    return manifest;
                }
                catch (IOException e) {
                    LOGGER.error(MessageFormat.format("Error closing stream: {0}", e.getMessage()), (Throwable)e);
                }
                return manifest;
            }
            jis = new JarInputStream(urlConnection.getInputStream());
            Manifest manifest = ((JarInputStream)jis).getManifest();
            if (jis == null) return manifest;
            try {
                jis.close();
                return manifest;
            }
            catch (IOException e) {
                LOGGER.error(MessageFormat.format("Error closing stream: {0}", e.getMessage()), (Throwable)e);
            }
            return manifest;
            catch (IOException e) {
                try {
                    LOGGER.error(MessageFormat.format("Error reading META-INF/MANIFEST.MF file: {0}", e.getMessage()), (Throwable)e);
                    if (jis == null) return null;
                }
                catch (Throwable throwable) {
                    if (jis == null) throw throwable;
                    try {
                        jis.close();
                        throw throwable;
                    }
                    catch (IOException e2) {
                        LOGGER.error(MessageFormat.format("Error closing stream: {0}", e2.getMessage()), (Throwable)e2);
                    }
                    throw throwable;
                }
                try {
                    jis.close();
                    return null;
                }
                catch (IOException e3) {
                    LOGGER.error(MessageFormat.format("Error closing stream: {0}", e3.getMessage()), (Throwable)e3);
                }
                return null;
            }
        }

        boolean containsDataFromManifest() {
            return this.containsDataFromManifest;
        }

        public String getRevision() {
            return this.scmRevision;
        }

        public String getVersion() {
            return this.fullVersionString;
        }

        public String getResourceVersion() {
            return this.resourceVersion;
        }

        public String getImplementationTitle() {
            return this.implementationTitle;
        }

        public String getImplementationVendor() {
            return this.implementationVendor;
        }

        public String getImplementationVersion() {
            return this.implementationVersion;
        }

        public String getScmRevision() {
            return this.scmRevision;
        }

        public String getScmTimestamp() {
            return this.scmTimestamp;
        }

        public String toString() {
            return this.getVersion();
        }
    }
}

