/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.application;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.MessageFormat;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PostConstructApplicationEvent;
import javax.faces.event.PreDestroyApplicationEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.ajax4jsf.cache.CacheManager;
import org.ajax4jsf.renderkit.AJAXDataSerializer;
import org.ajax4jsf.resource.util.URLToStreamHelper;
import org.richfaces.application.ServiceTracker;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.skin.SkinFactory;
import org.richfaces.skin.SkinFactoryImpl;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitializationListener
implements SystemEventListener {
    private static final String META_INF_SERVICES = "META-INF/services/";
    private static final Logger LOG = RichfacesLogger.APPLICATION.getLogger();

    public boolean isListenerForSource(Object source) {
        return true;
    }

    private static <T> T instantiate(Class<T> interfaceClass, Class<? extends T> implementationClass, Class<? extends T> defaultImplementationClass) {
        Constructor<T> constructor = null;
        Object[] constructorArguments = null;
        if (implementationClass != null) {
            if (defaultImplementationClass != null && !defaultImplementationClass.equals(implementationClass)) {
                try {
                    constructor = implementationClass.getConstructor(interfaceClass);
                    T defaultImplementation = InitializationListener.instantiate(interfaceClass, defaultImplementationClass, null);
                    constructorArguments = new Object[]{defaultImplementation};
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            if (constructor == null) {
                try {
                    constructor = implementationClass.getConstructor(new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new FacesException(MessageFormat.format("Class {0} has no public no-arg constructor", implementationClass.getName()), (Throwable)e);
                }
            }
        } else {
            try {
                constructor = defaultImplementationClass.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new FacesException(MessageFormat.format("Class {0} has no public no-arg constructor", defaultImplementationClass.getName()), (Throwable)e);
            }
        }
        try {
            return constructor.newInstance(constructorArguments);
        }
        catch (IllegalArgumentException e) {
            throw new FacesException(MessageFormat.format("Cannot instantiate {0} class, error was: {1}", constructor.getDeclaringClass(), e.getMessage()), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new FacesException(MessageFormat.format("Cannot instantiate {0} class, error was: {1}", constructor.getDeclaringClass(), e.getMessage()), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new FacesException(MessageFormat.format("Cannot instantiate {0} class, error was: {1}", constructor.getDeclaringClass(), e.getMessage()), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new FacesException(MessageFormat.format("Cannot instantiate {0} class, error was: {1}", constructor.getDeclaringClass(), cause.getMessage()), cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T createServiceInstance(Class<T> interfaceClass, Class<? extends T> defaultImplementationClass) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream input = URLToStreamHelper.urlToStreamSafe((URL)loader.getResource(META_INF_SERVICES + interfaceClass.getName()));
        Class<T> implementationClass = null;
        if (input != null) {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(input));
                String factoryClassName = reader.readLine();
                implementationClass = Class.forName(factoryClassName, false, loader).asSubclass(interfaceClass);
            }
            catch (Exception e) {
                LOG.warn(MessageFormat.format("Error loading class for {0} service: {1} ", interfaceClass.getName(), e.getMessage()), (Throwable)e);
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
        }
        return InitializationListener.instantiate(interfaceClass, implementationClass, defaultImplementationClass);
    }

    protected void onStart() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        SkinFactory skinFactory = InitializationListener.createServiceInstance(SkinFactory.class, SkinFactoryImpl.class);
        ServiceTracker.setService((FacesContext)facesContext, SkinFactory.class, (Object)skinFactory);
        AJAXDataSerializer dataSerializer = InitializationListener.createServiceInstance(AJAXDataSerializer.class, AJAXDataSerializer.class);
        ServiceTracker.setService((FacesContext)facesContext, AJAXDataSerializer.class, (Object)dataSerializer);
    }

    protected void onStop() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ServiceTracker.release((FacesContext)facesContext);
        CacheManager.getInstance().destroy();
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        if (event instanceof PostConstructApplicationEvent) {
            this.onStart();
        } else if (event instanceof PreDestroyApplicationEvent) {
            this.onStop();
        } else {
            throw new IllegalArgumentException(MessageFormat.format("Event {0} is not supported!", event));
        }
    }
}

