/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

public final class AbstractMessageUtil {
    private AbstractMessageUtil() {
    }

    private static ResourceBundle getResourceBundle(String baseName, Locale locale, ClassLoader loader) {
        if (loader != null) {
            return ResourceBundle.getBundle(baseName, locale, loader);
        }
        return ResourceBundle.getBundle(baseName, locale);
    }

    private static FacesMessage getMessage(FacesContext context, String messageId, Object[] parameters, Locale locale, String baseBundleName) {
        ResourceBundle bundle;
        String messageBundleName;
        Application application;
        String summary = null;
        String detail = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (context != null && (application = context.getApplication()) != null && (messageBundleName = application.getMessageBundle()) != null && (bundle = AbstractMessageUtil.getResourceBundle(messageBundleName, locale, loader)) != null) {
            try {
                summary = bundle.getString(messageId);
                detail = bundle.getString(messageId + "_detail");
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        if (summary == null) {
            ResourceBundle bundle2 = AbstractMessageUtil.getResourceBundle(baseBundleName, locale, loader);
            try {
                summary = bundle2.getString(messageId);
                if (summary == null) {
                    return null;
                }
                detail = bundle2.getString(messageId + "_detail");
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        String formattedSummary = MessageFormat.format(summary, parameters);
        String formattedDetail = null;
        if (detail != null) {
            formattedDetail = MessageFormat.format(detail, parameters);
        }
        return new FacesMessage(formattedSummary, formattedDetail);
    }

    static FacesMessage getMessage(FacesContext context, String messageId, Object[] parameters, String baseBundleName) {
        Locale locale;
        UIViewRoot viewRoot;
        FacesMessage result = null;
        if (context != null && (viewRoot = context.getViewRoot()) != null && (locale = viewRoot.getLocale()) != null) {
            result = AbstractMessageUtil.getMessage(context, messageId, parameters, locale, baseBundleName);
        }
        if (result == null) {
            locale = Locale.getDefault();
            result = AbstractMessageUtil.getMessage(context, messageId, parameters, locale, baseBundleName);
        }
        return result;
    }
}

