/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.context;

import java.util.List;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.ajax4jsf.context.ContextInitParameters;
import org.richfaces.el.BaseReadOnlyValueExpression;

public class SkinningResourcesPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 7430448731396547419L;
    private static final String SKINNING_RESOURCE_MARKER = SkinningResourcesPhaseListener.class.getName();
    private static final String CLASSES_ECSS = "_classes.ecss";
    private static final String ECSS = ".ecss";
    private static final String BOTH_ECSS = "_both.ecss";
    private static final String CONTROLS_SKINNING;
    private static final String BOTH_SKINNING;
    private static final String CLASSES_SKINNING;
    private static final String HEAD = "head";

    private UIComponent createComponentResource(FacesContext context) {
        Application application = context.getApplication();
        String rendererType = application.getResourceHandler().getRendererTypeForResourceName(BOTH_SKINNING);
        UIComponent resourceComponent = application.createComponent(context, "javax.faces.Output", rendererType);
        return resourceComponent;
    }

    public void afterPhase(PhaseEvent event) {
    }

    public void beforePhase(PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        UIViewRoot viewRoot = context.getViewRoot();
        assert (viewRoot != null);
        boolean skinnigResourceFound = false;
        List resources = viewRoot.getComponentResources(context, HEAD);
        for (UIComponent resource : resources) {
            if (resource.getAttributes().get(SKINNING_RESOURCE_MARKER) == null) continue;
            skinnigResourceFound = true;
            break;
        }
        if (!skinnigResourceFound) {
            UIComponent basic = this.createComponentResource(context);
            basic.setValueExpression("name", (ValueExpression)new SkinningResourceNameExpression());
            basic.setValueExpression("rendered", (ValueExpression)new SkinningResourceRenderedExpression());
            basic.getAttributes().put(SKINNING_RESOURCE_MARKER, Boolean.TRUE);
            viewRoot.addComponentResource(context, basic);
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }

    static {
        String skinningName = "skinning";
        CONTROLS_SKINNING = skinningName + ECSS;
        BOTH_SKINNING = skinningName + BOTH_ECSS;
        CLASSES_SKINNING = skinningName + CLASSES_ECSS;
    }

    private static final class SkinningResourceRenderedExpression
    extends BaseReadOnlyValueExpression {
        private static final long serialVersionUID = -1579256471133808739L;

        public SkinningResourceRenderedExpression() {
            super(Boolean.TYPE);
        }

        public Object getValue(ELContext context) {
            FacesContext facesContext = this.getFacesContext(context);
            return ContextInitParameters.isStandardControlSkinningEnabled(facesContext) || ContextInitParameters.isStandardControlSkinningClassesEnabled(facesContext);
        }
    }

    private static final class SkinningResourceNameExpression
    extends BaseReadOnlyValueExpression {
        private static final long serialVersionUID = 7520575496522682120L;

        public SkinningResourceNameExpression() {
            super(String.class);
        }

        public Object getValue(ELContext context) {
            FacesContext facesContext = this.getFacesContext(context);
            boolean controls = ContextInitParameters.isStandardControlSkinningEnabled(facesContext);
            boolean classes = ContextInitParameters.isStandardControlSkinningClassesEnabled(facesContext);
            if (controls && classes) {
                return BOTH_SKINNING;
            }
            if (classes) {
                return CLASSES_SKINNING;
            }
            return CONTROLS_SKINNING;
        }
    }
}

