/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.ajax4jsf.renderkit.AjaxChildrenRenderer;
import org.richfaces.renderkit.AttributeParametersEncoder;
import org.richfaces.renderkit.RendererContributor;
import org.richfaces.renderkit.ScriptOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompositeRenderer
extends AjaxChildrenRenderer {
    private static final Command MERGE_OPTIONS_COMMAND = new Command(){

        protected void execute(RendererContributor renderer, FacesContext context, UIComponent component, Object argument) {
            ScriptOptions initialOptions = (ScriptOptions)((Object)argument);
            ScriptOptions builtOptions = renderer.buildOptions(context, component);
            if (builtOptions != null) {
                initialOptions.merge(builtOptions);
            }
        }
    };
    private static final Command GET_SCRIPT_CONTRIBUTIONS = new Command(){

        protected void execute(RendererContributor renderer, FacesContext context, UIComponent component, Object argument) {
            String contribution = renderer.getScriptContribution(context, component);
            if (contribution != null) {
                ((List)argument).add(contribution);
            }
        }
    };
    private List<RendererContributor> renderers = new ArrayList<RendererContributor>();
    private List<AttributeParametersEncoder> parameterEncoders = new ArrayList<AttributeParametersEncoder>();
    private final Command decodeCommand = new Command(){

        protected void execute(RendererContributor renderer, FacesContext context, UIComponent component, Object argument) {
            renderer.decode(context, component, CompositeRenderer.this);
        }
    };

    @Override
    protected void doDecode(FacesContext context, UIComponent component) {
        super.doDecode(context, component);
        this.decodeCommand.execute(this.renderers.iterator(), context, component, null, component.getClass());
    }

    protected void mergeScriptOptions(ScriptOptions scriptOptions, FacesContext context, UIComponent component) {
        this.mergeScriptOptions(scriptOptions, context, component, null);
    }

    protected void mergeScriptOptions(ScriptOptions scriptOptions, FacesContext context, UIComponent component, Class<?> acceptableClass) {
        MERGE_OPTIONS_COMMAND.execute(this.renderers.iterator(), context, component, (Object)scriptOptions, acceptableClass);
    }

    protected String getScriptContributions(String varString, FacesContext context, UIComponent component) {
        return this.getScriptContributions(varString, context, component, component.getClass());
    }

    protected String getScriptContributions(String varString, FacesContext context, UIComponent component, Class<?> acceptableClass) {
        ArrayList scriptContributions = new ArrayList();
        GET_SCRIPT_CONTRIBUTIONS.execute(this.renderers.iterator(), context, component, scriptContributions, acceptableClass);
        StringBuffer result = new StringBuffer();
        Iterator itr = scriptContributions.iterator();
        while (itr.hasNext()) {
            result.append(varString);
            result.append((String)itr.next());
        }
        return result.toString();
    }

    protected void addContributor(RendererContributor renderer) {
        this.renderers.add(renderer);
    }

    protected RendererContributor[] getContributors() {
        return this.renderers.toArray(new RendererContributor[this.renderers.size()]);
    }

    protected void addParameterEncoder(AttributeParametersEncoder encoder) {
        this.parameterEncoders.add(encoder);
    }

    protected AttributeParametersEncoder[] getParameterEncoders() {
        return this.parameterEncoders.toArray(new AttributeParametersEncoder[this.renderers.size()]);
    }

    public void encodeAttributeParameters(FacesContext context, UIComponent component) throws IOException {
        for (AttributeParametersEncoder encoder : this.parameterEncoders) {
            encoder.doEncode(context, component);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Command {
        private Command() {
        }

        protected final void execute(Iterator<?> renderers, FacesContext facesContext, UIComponent component, Object argument, Class<?> clazz) {
            while (renderers.hasNext()) {
                RendererContributor contributor = (RendererContributor)renderers.next();
                Class<?> acceptableClass = contributor.getAcceptableClass();
                if (clazz != null && acceptableClass != null && !acceptableClass.isAssignableFrom(clazz)) continue;
                this.execute(contributor, facesContext, component, argument);
            }
        }

        protected abstract void execute(RendererContributor var1, FacesContext var2, UIComponent var3, Object var4);
    }
}

