/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.faces.context.FacesContext;
import org.ajax4jsf.resource.Java2Dresource;
import org.ajax4jsf.util.NumericDataInputStream;
import org.ajax4jsf.util.NumericDataOutputStream;
import org.richfaces.renderkit.html.images.GradientType;
import org.richfaces.resource.DynamicResource;

@DynamicResource
public class BaseGradient
extends Java2Dresource {
    protected Integer headerBackgroundColor;
    protected Integer headerGradientColor;
    protected GradientType gradientType;
    private final int width;
    private final int height;
    private final int gradientHeight;
    private final String baseColor;
    private final String gradientColor;
    private final boolean horizontal;

    public BaseGradient(int width, int height, int gradientHeight, String baseColor, String gradientColor, boolean horizontal) {
        super(Java2Dresource.ImageType.PNG);
        this.width = width;
        this.height = height;
        this.gradientHeight = gradientHeight;
        this.baseColor = baseColor != null ? baseColor : "headerBackgroundColor";
        this.gradientColor = gradientColor != null ? gradientColor : "headerGradientColor";
        this.horizontal = horizontal;
        this.initialize();
    }

    public BaseGradient(int width, int height, int gradientHeight) {
        this(width, height, gradientHeight, null, null, false);
    }

    public BaseGradient(int width, int height, int gradientHeight, String baseColor, String gradientColor) {
        this(width, height, gradientHeight, baseColor, gradientColor, false);
    }

    public BaseGradient(int width, int height) {
        this(width, height, height);
    }

    public BaseGradient(int width, int height, String baseColor, String gradientColor) {
        this(width, height, height, baseColor, gradientColor);
    }

    public BaseGradient() {
        this(30, 50, 20);
    }

    public BaseGradient(String baseColor, String gradientColor) {
        this(30, 50, 20, baseColor, gradientColor);
    }

    public BaseGradient(int width, int height, int gradientHeight, boolean horizontal) {
        this(width, height, gradientHeight, null, null, horizontal);
    }

    public BaseGradient(int width, int height, boolean horizontal) {
        this(width, height, horizontal ? width : height, null, null, horizontal);
    }

    public BaseGradient(int width, int height, String baseColor, String gradientColor, boolean horizontal) {
        this(width, height, horizontal ? width : height, baseColor, gradientColor, horizontal);
    }

    public BaseGradient(boolean horizontal) {
        this(30, 50, 20, null, null, horizontal);
    }

    public BaseGradient(String baseColor, String gradientColor, boolean horizontal) {
        this(30, 50, 20, baseColor, gradientColor, horizontal);
    }

    private void initialize() {
        FacesContext context = FacesContext.getCurrentInstance();
        Integer baseIntColor = null;
        Integer headerIntColor = null;
        String gradientTypeString = null;
        if (baseIntColor == null) {
            baseIntColor = this.getColorValueParameter(context, this.baseColor, false);
        }
        if (headerIntColor == null) {
            headerIntColor = this.getColorValueParameter(context, this.gradientColor, false);
        }
        if (baseIntColor != null || headerIntColor != null) {
            if (baseIntColor == null) {
                baseIntColor = this.getColorValueParameter(context, this.baseColor, true);
            }
            if (headerIntColor == null) {
                headerIntColor = this.getColorValueParameter(context, this.gradientColor, true);
            }
        }
        this.headerBackgroundColor = baseIntColor;
        this.headerGradientColor = headerIntColor;
        if (gradientTypeString == null || gradientTypeString.length() == 0) {
            gradientTypeString = this.getValueParameter(context, "gradientType");
        }
        this.gradientType = GradientType.getByParameter(gradientTypeString);
    }

    public Dimension getDimension() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    protected int getGradientHeight() {
        return this.gradientHeight;
    }

    protected int getHeight() {
        return this.height;
    }

    protected int getWidth() {
        return this.width;
    }

    protected String getBaseColor() {
        return this.baseColor;
    }

    protected String getGradientColor() {
        return this.gradientColor;
    }

    protected boolean isHorizontal() {
        return this.horizontal;
    }

    protected void drawGradient(Graphics2D g2d, Shape shape, GradientType.BiColor colors, int height) {
        if (colors != null) {
            GradientPaint gragient = new GradientPaint(0.0f, 0.0f, colors.getTopColor(), 0.0f, height, colors.getBottomColor());
            g2d.setPaint(gragient);
            g2d.fill(shape);
        }
    }

    protected void paint(Graphics2D graphics2d, Dimension dimension) {
        super.paint(graphics2d, dimension);
        graphics2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.paintGradient(graphics2d, dimension);
    }

    protected void paintGradient(Graphics2D g2d, Dimension dim) {
        if ((this.headerBackgroundColor != null || this.headerGradientColor != null) && this.gradientType != null) {
            int localGradientHeight;
            GradientType.BiColor biColor = new GradientType.BiColor(this.headerBackgroundColor, this.headerGradientColor);
            GradientType.BiColor firstLayer = this.gradientType.getFirstLayerColors(biColor);
            GradientType.BiColor secondLayer = this.gradientType.getSecondLayerColors(biColor);
            if (this.horizontal) {
                g2d.transform(new AffineTransform(0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f));
                dim.setSize(dim.height, dim.width);
            }
            if ((localGradientHeight = this.gradientHeight) < 0) {
                localGradientHeight = dim.height;
            }
            Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, 0.0f, dim.width, dim.height);
            this.drawGradient(g2d, rect, firstLayer, localGradientHeight);
            int smallGradientHeight = localGradientHeight / 2;
            rect = new Rectangle2D.Float(0.0f, 0.0f, dim.width, smallGradientHeight);
            this.drawGradient(g2d, rect, secondLayer, smallGradientHeight);
        }
    }

    protected void readState(FacesContext context, NumericDataInputStream stream) {
        super.readState(context, stream);
        this.headerBackgroundColor = stream.readInt();
        this.headerGradientColor = stream.readInt();
        this.gradientType = GradientType.values()[stream.readByte()];
    }

    protected void writeState(FacesContext context, NumericDataOutputStream stream) {
        super.writeState(context, stream);
        stream.writeInt(this.headerBackgroundColor);
        stream.writeInt(this.headerGradientColor);
        stream.writeByte((byte)this.gradientType.ordinal());
    }

    public boolean isCacheable() {
        return true;
    }
}

