/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.ajax4jsf.resource.Java2Dresource;
import org.ajax4jsf.util.NumericDataInputStream;
import org.ajax4jsf.util.NumericDataOutputStream;
import org.richfaces.renderkit.html.images.GradientAlignment;
import org.richfaces.renderkit.html.images.GradientType;
import org.richfaces.resource.DynamicResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DynamicResource
public class CustomizeableGradient
extends Java2Dresource {
    private static final String BASE_COLOR = "baseColor";
    private static final String GRADIENT_COLOR = "gradientColor";
    protected Dimension dimension = new Dimension(20, 500);
    protected Integer gradientColor;
    protected Integer baseColor;
    protected Integer gradientHeight = 22;
    protected GradientType gradientType;
    protected GradientAlignment gradientAlignment;

    public CustomizeableGradient() {
        super(Java2Dresource.ImageType.PNG);
        String gradientTypeString = CustomizeableGradient.safeTrim(this.getValueParameter(FacesContext.getCurrentInstance(), "gradientType"));
        if (gradientTypeString != null && gradientTypeString.length() != 0) {
            this.gradientType = GradientType.getByParameter(gradientTypeString);
        }
    }

    @Override
    public void populateParameters(Map<String, String> parameters) {
        if (parameters.containsKey(GRADIENT_COLOR)) {
            String gradientColorValue = this.encodeSkinParameter(parameters.get(GRADIENT_COLOR));
            this.gradientColor = this.decodeColor(gradientColorValue);
        }
        if (parameters.containsKey(BASE_COLOR)) {
            String baseColorValue = this.encodeSkinParameter(parameters.get(BASE_COLOR));
            this.baseColor = this.decodeColor(baseColorValue);
        }
    }

    @Override
    public Dimension getDimension() {
        return this.dimension;
    }

    private void drawRectangle(Graphics2D g2d, Rectangle2D rect, GradientType.BiColor biColor, boolean useTop) {
        if (biColor != null) {
            Color color = useTop ? biColor.getTopColor() : biColor.getBottomColor();
            g2d.setColor(color);
            g2d.fill(rect);
        }
    }

    private void drawGradient(Graphics2D g2d, Rectangle2D rectangle, GradientType.BiColor colors, int height) {
        if (colors != null) {
            GradientPaint gragient = new GradientPaint(0.0f, 0.0f, colors.getTopColor(), 0.0f, height, colors.getBottomColor());
            g2d.setPaint(gragient);
            g2d.fill(rectangle);
        }
    }

    @Override
    protected void paint(Graphics2D g2d, Dimension dim) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        if ((this.gradientColor != null || this.baseColor != null) && this.gradientType != null && this.gradientAlignment != null) {
            this.paintGradient(g2d, dim);
        }
    }

    protected void paintGradient(Graphics2D g2d, Dimension dim) {
        GradientType.BiColor biColor = new GradientType.BiColor(this.gradientColor, this.baseColor);
        GradientType.BiColor firstLayer = this.gradientType.getFirstLayerColors(biColor);
        GradientType.BiColor secondLayer = this.gradientType.getSecondLayerColors(biColor);
        Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, 0.0f, dim.width, dim.height);
        int topRectangleHeight = this.gradientAlignment.getTopRectangleHeight(dim.height, this.gradientHeight);
        int bottomRectangleHeight = this.gradientAlignment.getBottomRectangleHeight(dim.height, this.gradientHeight);
        rect = new Rectangle2D.Float(0.0f, 0.0f, dim.width, topRectangleHeight);
        this.drawRectangle(g2d, rect, firstLayer, true);
        this.drawRectangle(g2d, rect, secondLayer, true);
        rect = new Rectangle2D.Float(0.0f, dim.height - bottomRectangleHeight, dim.width, dim.height);
        this.drawRectangle(g2d, rect, firstLayer, false);
        this.drawRectangle(g2d, rect, secondLayer, false);
        g2d.transform(AffineTransform.getTranslateInstance(0.0, topRectangleHeight));
        rect = new Rectangle2D.Float(0.0f, 0.0f, dim.width, dim.height);
        this.drawGradient(g2d, rect, firstLayer, this.gradientHeight);
        rect = new Rectangle2D.Float(0.0f, 0.0f, dim.width, this.gradientHeight / 2);
        this.drawGradient(g2d, rect, secondLayer, this.gradientHeight / 2);
    }

    @Override
    protected void readState(FacesContext context, NumericDataInputStream stream) {
        super.readState(context, stream);
        this.baseColor = stream.readIntColor();
        this.gradientColor = stream.readIntColor();
        this.gradientHeight = stream.readInt();
        this.gradientAlignment = GradientAlignment.values()[stream.readByte()];
        this.gradientType = GradientType.values()[stream.readByte()];
    }

    @Override
    protected void writeState(FacesContext context, NumericDataOutputStream stream) {
        super.writeState(context, stream);
        stream.writeIntColor(this.baseColor);
        stream.writeIntColor(this.gradientColor);
        stream.writeInt(this.gradientHeight);
        stream.writeByte((byte)this.gradientAlignment.ordinal());
        stream.writeByte((byte)this.gradientType.ordinal());
    }

    protected static String safeTrim(String s) {
        return s != null ? s.trim() : null;
    }

    public boolean isCacheable() {
        return true;
    }

    public Integer getGradientColor() {
        return this.gradientColor;
    }

    public void setGradientColor(Integer headerBackgroundColor) {
        this.gradientColor = headerBackgroundColor;
    }

    public void setGradientColorString(String colorString) {
        this.setGradientColor(this.decodeColor(colorString));
    }

    public Integer getBaseColor() {
        return this.baseColor;
    }

    public void setBaseColor(Integer headerGradientColor) {
        this.baseColor = headerGradientColor;
    }

    public void setBaseColorString(String colorString) {
        this.setBaseColor(this.decodeColor(colorString));
    }

    public GradientType getGradientType() {
        return this.gradientType;
    }

    public void setGradientType(GradientType gradientType) {
        this.gradientType = gradientType;
    }

    public GradientAlignment getGradientAlignment() {
        return this.gradientAlignment;
    }

    public void setGradientAlignment(GradientAlignment gradientAlignment) {
        this.gradientAlignment = gradientAlignment;
    }

    public Integer getGradientHeight() {
        return this.gradientHeight;
    }

    public void setGradientHeight(Integer gradientHeight) {
        this.gradientHeight = gradientHeight;
    }
}

