/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import java.util.Date;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.resource.ResourceUtils;
import org.richfaces.util.Util;
import org.slf4j.Logger;

public abstract class AbstractCacheableResource
extends Resource {
    private static final Logger LOGGER = RichfacesLogger.RESOURCE.getLogger();

    protected abstract Date getLastModified(FacesContext var1);

    public abstract boolean isCacheable(FacesContext var1);

    protected abstract String getEntityTag(FacesContext var1);

    private static boolean isUserCopyActual(Date lastModified, Date modifiedCondition) {
        return lastModified.getTime() - modifiedCondition.getTime() <= 1000L;
    }

    @Deprecated
    protected Boolean isMatchesLastModified(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        Map requestHeaderMap = externalContext.getRequestHeaderMap();
        String modifiedCondition = (String)requestHeaderMap.get("If-Modified-Since");
        if (modifiedCondition == null) {
            return null;
        }
        return this.isMatchesLastModified(context, modifiedCondition);
    }

    protected boolean isMatchesLastModified(FacesContext context, String modifiedCondition) {
        Date lastModified = this.getLastModified(context);
        if (lastModified == null) {
            return false;
        }
        return AbstractCacheableResource.isUserCopyActual(lastModified, Util.parseHttpDate(modifiedCondition));
    }

    @Deprecated
    protected Boolean isMatchesEntityTag(FacesContext context) {
        ExternalContext externalContext = context.getExternalContext();
        Map requestHeaderMap = externalContext.getRequestHeaderMap();
        String matchHeaderValue = (String)requestHeaderMap.get("If-None-Match");
        if (matchHeaderValue == null) {
            return null;
        }
        return this.isMatchesEntityTag(context, matchHeaderValue);
    }

    protected boolean isMatchesEntityTag(FacesContext context, String matchHeaderValue) {
        String resourceEntityTag = this.getEntityTag(context);
        if (resourceEntityTag == null) {
            return false;
        }
        return ResourceUtils.matchTag(resourceEntityTag, matchHeaderValue);
    }

    public boolean userAgentNeedsUpdate(FacesContext context) {
        if (!this.isCacheable(context)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("User agent cache check: resource is not cacheable");
            }
            return true;
        }
        ExternalContext externalContext = context.getExternalContext();
        Map requestHeaderMap = externalContext.getRequestHeaderMap();
        String modifiedCondition = (String)requestHeaderMap.get("If-Modified-Since");
        String matchHeaderValue = (String)requestHeaderMap.get("If-None-Match");
        if (modifiedCondition == null && matchHeaderValue == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("User agent cache check: no cache information was provided in request");
            }
            return true;
        }
        if (matchHeaderValue != null && !this.isMatchesEntityTag(context, matchHeaderValue)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("User agent cache check: entity tags don't match");
            }
            return true;
        }
        if (modifiedCondition != null && !this.isMatchesLastModified(context, modifiedCondition)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("User agent cache check: resource was modified since the last request");
            }
            return true;
        }
        return false;
    }
}

