/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import com.steadystate.css.parser.CSSOMParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.resource.AbstractBaseResource;
import org.richfaces.resource.css.CSSVisitorImpl;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;
import org.slf4j.Logger;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.css.CSSStyleSheet;

public class CompiledCSSResource
extends AbstractBaseResource
implements StateHolder {
    private static final String ECSS = ".ecss";
    private static final String CLASSPATH_BASE_PATH = "META-INF/resources/";
    private static final String WEBAPP_BASE_PATH = "/resources/";
    private static final Logger LOGGER = RichfacesLogger.RESOURCE.getLogger();
    private static final String NULL_STYLESHEET = "Parsed stylesheet for ''{0}'':''{1}'' resource is null.";
    private String resourcePath;

    public CompiledCSSResource(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public String getResourceName() {
        return this.resourcePath;
    }

    public InputStream getResourceInputStream() throws IOException {
        String path = null;
        if (this.resourcePath.indexOf(ECSS) == -1) {
            LOGGER.error("This resource is not properly dynamic resource : " + this.getResourceName());
            return null;
        }
        path = this.resourcePath.substring(0, this.resourcePath.lastIndexOf(ECSS) + ECSS.length());
        InputStream in = null;
        try {
            in = FacesContext.getCurrentInstance().getExternalContext().getResourceAsStream(WEBAPP_BASE_PATH + path);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (in != null) {
            return in;
        }
        ClassLoader loader = this.getClassLoader();
        in = loader.getResourceAsStream(CLASSPATH_BASE_PATH + path);
        if (in == null) {
            in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(CLASSPATH_BASE_PATH + path);
        }
        return in;
    }

    public static ClassLoader getCurrentLoader(Object fallbackClass) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = fallbackClass.getClass().getClassLoader();
        }
        return loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws IOException {
        FacesContext ctx = FacesContext.getCurrentInstance();
        InputStream stream = null;
        CSSStyleSheet styleSheet = null;
        try {
            stream = this.getResourceInputStream();
            if (null == stream) {
                InputStream inputStream = null;
                return inputStream;
            }
            InputSource source = new InputSource((Reader)new InputStreamReader(stream));
            CSSOMParser parser = new CSSOMParser();
            ErrorHandlerImpl errorHandler = new ErrorHandlerImpl(this, ctx.isProjectStage(ProjectStage.Production));
            parser.setErrorHandler((ErrorHandler)errorHandler);
            styleSheet = parser.parseStyleSheet(source, null, null);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    LOGGER.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (styleSheet != null) {
            String encoding = FacesContext.getCurrentInstance().getExternalContext().getResponseCharacterEncoding();
            CSSVisitorImpl cssVisitor = new CSSVisitorImpl();
            cssVisitor.setEncoding(encoding != null ? encoding : "UTF-8");
            cssVisitor.visitStyleSheet(styleSheet);
            String cssText = cssVisitor.getCSSText();
            return new ByteArrayInputStream(cssText.getBytes(cssVisitor.getEncoding()));
        }
        if (!ctx.isProjectStage(ProjectStage.Production)) {
            LOGGER.info(MessageFormat.format(NULL_STYLESHEET, this.getLibraryName(), this.getResourceName()));
        }
        return null;
    }

    public String getContentType() {
        return "text/css";
    }

    private static int getSkinHashCode(FacesContext context) {
        Skin skin = SkinFactory.getInstance().getSkin(context);
        return skin.hashCode(context);
    }

    public boolean userAgentNeedsUpdate(FacesContext context) {
        if (context.isProjectStage(ProjectStage.Development)) {
            return true;
        }
        return super.userAgentNeedsUpdate(context);
    }

    public boolean isTransient() {
        return false;
    }

    public void restoreState(FacesContext context, Object state) {
    }

    public Object saveState(FacesContext context) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(CompiledCSSResource.getSkinHashCode(context));
        return buffer.array();
    }

    public void setTransient(boolean newTransientValue) {
    }

    private static final class ErrorHandlerImpl
    implements ErrorHandler {
        private boolean productionStage;
        private Resource resource;
        private String resourceLocator;

        public ErrorHandlerImpl(Resource resource, boolean productionStage) {
            this.resource = resource;
            this.productionStage = productionStage;
        }

        private String getResourceLocator() {
            if (this.resourceLocator == null) {
                String libraryName = this.resource.getLibraryName();
                String resourceName = this.resource.getResourceName();
                this.resourceLocator = libraryName != null && libraryName.length() != 0 ? libraryName + '/' + resourceName : resourceName;
            }
            return this.resourceLocator;
        }

        private void logException(CSSParseException e) {
            String formattedMessage = MessageFormat.format("Problem parsing ''{0}'' resource: {1}", this.getResourceLocator(), e.getMessage());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(formattedMessage, (Throwable)e);
            } else {
                LOGGER.warn(formattedMessage);
            }
        }

        public void error(CSSParseException e) throws CSSException {
            this.logException(e);
        }

        public void fatalError(CSSParseException e) throws CSSException {
            this.logException(e);
        }

        public void warning(CSSParseException e) throws CSSException {
            this.logException(e);
        }
    }
}

