/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.richfaces.component;

import java.util.List;

import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;

import org.ajax4jsf.context.ContextInitParameters;

/**
 * @author Nick Belaevski
 * 
 */
public class QueuePreRenderViewListener implements SystemEventListener {

    private static final String HEAD = "head";

    private static final String QUEUE_RESOURCE_COMPONENT_RENDERER_TYPE = "org.richfaces.QueueResourceComponentRenderer";
    
    public boolean isListenerForSource(Object source) {
        return true;
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        FacesContext context = FacesContext.getCurrentInstance();
        UIViewRoot viewRoot = context.getViewRoot();
        List<UIComponent> resources = viewRoot.getComponentResources(context, HEAD);
        
        boolean queueEnabled = ContextInitParameters.isQueueEnabled(context);
        
        boolean resourceExists = false;
        for (UIComponent resourceComponent : resources) {
            if (QUEUE_RESOURCE_COMPONENT_RENDERER_TYPE.equals(resourceComponent.getRendererType()) && 
                UIOutput.COMPONENT_FAMILY.equals(resourceComponent.getFamily())) {
                
                if (!queueEnabled) {
                    viewRoot.removeComponentResource(context, resourceComponent);
                }
                
                resourceExists = true;
                break;
            }
        }

        if (!resourceExists && queueEnabled) {
            Application application = context.getApplication();
            UIComponent queueResourceComponent = application.createComponent(context, 
                UIOutput.COMPONENT_TYPE, QUEUE_RESOURCE_COMPONENT_RENDERER_TYPE);
            
            viewRoot.addComponentResource(context, queueResourceComponent);
        }
    }

}
