package org.richfaces.renderkit.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.richfaces.renderkit.AjaxFunctionRendererBase;
import org.richfaces.renderkit.RenderKitUtils;


public class AjaxFunctionRenderer extends AjaxFunctionRendererBase {
	
	
private static final String convertToString(Object object) 
 {
			return object != null ? object.toString() : "";
	}
	
@Override
public void encodeEnd(FacesContext facesContext, UIComponent component) 
		throws IOException
	 {
			ResponseWriter responseWriter = facesContext.getResponseWriter(); 
String clientId = component.getClientId(facesContext);
			responseWriter.startElement("span", component); 
			RenderKitUtils.renderAttribute(facesContext, "id", clientId/* #{clientId} */);
			RenderKitUtils.renderAttribute(facesContext, "style", "display: none;"/* display: none; */);
			responseWriter.startElement("script", component); 
			RenderKitUtils.renderAttribute(facesContext, "type", "text/javascript"/* text/javascript */);
			{
	Object text = convertToString(this.getFunction(facesContext,component)) + ";"/* #{this.getFunction(facesContext, component)}; */;
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}
			responseWriter.endElement("script"); 
			responseWriter.endElement("span"); 
	}
}

