package org.richfaces.renderkit.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.ajax4jsf.renderkit.RendererBase;
import org.richfaces.renderkit.RenderKitUtils;


public class AjaxLogRenderer extends RendererBase {
	
	
private static final String convertToString(Object object) 
 {
			return object != null ? object.toString() : "";
	}
	
@Override
public void encodeEnd(FacesContext facesContext, UIComponent component) 
		throws IOException
	 {
			ResponseWriter responseWriter = facesContext.getResponseWriter(); 
String clientId = component.getClientId(facesContext);
			responseWriter.startElement("div", component); 
			RenderKitUtils.renderAttribute(facesContext, "class", "rich-log " + convertToString(component.getAttributes().get("styleClass"))/* rich-log #{component.attributes['styleClass']} */);
			RenderKitUtils.renderAttribute(facesContext, "id", "richfaces.log"/* richfaces.log */);
			responseWriter.startElement("script", component); 
			RenderKitUtils.renderAttribute(facesContext, "type", "text/javascript"/* text/javascript */);
			{
	Object text = "RichFaces.log.setLevel(\"" + convertToString(component.getAttributes().get("level")) + "\");"/* RichFaces.log.setLevel("#{component.attributes['level']}"); */;
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}
			responseWriter.endElement("script"); 
			responseWriter.endElement("div"); 
	}
}

