package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.richfaces.renderkit.ComponentAttribute;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.renderkit.html.CommandButtonRendererBase;


public class CommandButtonRenderer extends CommandButtonRendererBase {
	
private static final Map<java.lang.String, org.richfaces.renderkit.ComponentAttribute> PASS_THROUGH_ATTRIBUTES = Collections.unmodifiableMap(ComponentAttribute.createMap(new ComponentAttribute("accept"), new ComponentAttribute("accesskey"), new ComponentAttribute("align"), new ComponentAttribute("alt"), new ComponentAttribute("checked"), new ComponentAttribute("class").setComponentAttributeName("styleClass"), new ComponentAttribute("dir"), new ComponentAttribute("disabled"), new ComponentAttribute("lang"), new ComponentAttribute("maxlength"), new ComponentAttribute("onblur"), new ComponentAttribute("onchange"), new ComponentAttribute("ondblclick"), new ComponentAttribute("onfocus"), new ComponentAttribute("onkeydown"), new ComponentAttribute("onkeypress"), new ComponentAttribute("onkeyup"), new ComponentAttribute("onmousedown"), new ComponentAttribute("onmousemove"), new ComponentAttribute("onmouseout"), new ComponentAttribute("onmouseover"), new ComponentAttribute("onmouseup"), new ComponentAttribute("onselect"), new ComponentAttribute("readonly"), new ComponentAttribute("size"), new ComponentAttribute("src"), new ComponentAttribute("style"), new ComponentAttribute("tabindex"), new ComponentAttribute("title"), new ComponentAttribute("usemap")));
	
	
@Override
public void encodeEnd(FacesContext facesContext, UIComponent component) 
		throws IOException
	 {
			ResponseWriter responseWriter = facesContext.getResponseWriter(); 
String clientId = component.getClientId(facesContext);
			responseWriter.startElement("input", component); 
			RenderKitUtils.renderAttribute(facesContext, "id", clientId/* #{clientId} */);
			RenderKitUtils.renderAttribute(facesContext, "name", clientId/* #{clientId} */);
			RenderKitUtils.renderAttribute(facesContext, "onclick", this.getOnClick(facesContext,component)/* #{this.getOnClick(facesContext, component)} */);
			RenderKitUtils.renderAttribute(facesContext, "value", component.getAttributes().get("value")/* #{component.attributes['value']} */);
			RenderKitUtils.renderPassThroughAttributes(facesContext, component, 
	PASS_THROUGH_ATTRIBUTES);
			encodeTypeAndImage(facesContext, component);;
			responseWriter.endElement("input"); 
	}
}

