package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.richfaces.renderkit.AjaxCommandRendererBase;
import org.richfaces.renderkit.ComponentAttribute;
import org.richfaces.renderkit.RenderKitUtils;


public class CommandLinkRenderer extends AjaxCommandRendererBase {
	
private static final Map<java.lang.String, org.richfaces.renderkit.ComponentAttribute> PASS_THROUGH_ATTRIBUTES = Collections.unmodifiableMap(ComponentAttribute.createMap(new ComponentAttribute("accesskey"), new ComponentAttribute("charset"), new ComponentAttribute("class").setComponentAttributeName("styleClass"), new ComponentAttribute("coords"), new ComponentAttribute("dir"), new ComponentAttribute("hreflang"), new ComponentAttribute("lang"), new ComponentAttribute("onblur"), new ComponentAttribute("ondblclick"), new ComponentAttribute("onfocus"), new ComponentAttribute("onkeydown"), new ComponentAttribute("onkeypress"), new ComponentAttribute("onkeyup"), new ComponentAttribute("onmousedown"), new ComponentAttribute("onmousemove"), new ComponentAttribute("onmouseout"), new ComponentAttribute("onmouseover"), new ComponentAttribute("onmouseup"), new ComponentAttribute("rel"), new ComponentAttribute("rev"), new ComponentAttribute("shape"), new ComponentAttribute("style"), new ComponentAttribute("tabindex"), new ComponentAttribute("target"), new ComponentAttribute("title"), new ComponentAttribute("type")));
	
private static final Map<java.lang.String, org.richfaces.renderkit.ComponentAttribute> PASS_THROUGH_ATTRIBUTES_0 = Collections.unmodifiableMap(ComponentAttribute.createMap(new ComponentAttribute("class").setComponentAttributeName("styleClass"), new ComponentAttribute("dir"), new ComponentAttribute("lang"), new ComponentAttribute("onclick"), new ComponentAttribute("ondblclick"), new ComponentAttribute("onkeydown"), new ComponentAttribute("onkeypress"), new ComponentAttribute("onkeyup"), new ComponentAttribute("onmousedown"), new ComponentAttribute("onmousemove"), new ComponentAttribute("onmouseout"), new ComponentAttribute("onmouseover"), new ComponentAttribute("onmouseup"), new ComponentAttribute("style"), new ComponentAttribute("title")));
	
	
private static final boolean convertToBoolean(Object object) 
 {
			if (object == null) {
    return false;
}

if (object instanceof Boolean) {
    return Boolean.TRUE.equals(object);
}

return Boolean.valueOf(object.toString());

	}
	
private static final String convertToString(Object object) 
 {
			return object != null ? object.toString() : "";
	}
	
@Override
public void encodeEnd(FacesContext facesContext, UIComponent component) 
		throws IOException
	 {
			ResponseWriter responseWriter = facesContext.getResponseWriter(); 
String clientId = component.getClientId(facesContext);
				if ((!convertToBoolean(component.getAttributes().get("disabled")))/* #{not component.attributes['disabled']} */) {
	responseWriter.startElement("a", component); 
	RenderKitUtils.renderAttribute(facesContext, "href", "#"/* # */);
	RenderKitUtils.renderAttribute(facesContext, "id", clientId/* #{clientId} */);
	RenderKitUtils.renderAttribute(facesContext, "name", clientId/* #{clientId} */);
	RenderKitUtils.renderAttribute(facesContext, "onclick", this.getOnClick(facesContext,component)/* #{this.getOnClick(facesContext, component)} */);
	RenderKitUtils.renderPassThroughAttributes(facesContext, component, 
	PASS_THROUGH_ATTRIBUTES);
	{
	Object text = convertToString(component.getAttributes().get("value"))/* #{component.attributes['value']} */;
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}
	renderChildren(facesContext, component);
	responseWriter.endElement("a"); 
	} else  { 
	responseWriter.startElement("span", component); 
	RenderKitUtils.renderAttribute(facesContext, "id", clientId/* #{clientId} */);
	RenderKitUtils.renderPassThroughAttributes(facesContext, component, 
	PASS_THROUGH_ATTRIBUTES_0);
	{
	Object text = convertToString(component.getAttributes().get("value"))/* #{component.attributes['value']} */;
	if (text != null) {
		responseWriter.writeText(text, null); 
	}
}
	renderChildren(facesContext, component);
	responseWriter.endElement("span"); 
}
	}
	
@Override
public boolean getRendersChildren() 
 {
			return true;
	}
}

