/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.utils.focus;

import com.google.common.base.Predicate;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.richfaces.utils.focus.FocusRetriever;

public class ElementIsFocused
implements Predicate<WebDriver> {
    private WebElement activeElement;
    private final WebElement element;

    public ElementIsFocused(WebElement element) {
        this.element = element;
    }

    public boolean apply(WebDriver browser) {
        try {
            this.activeElement = FocusRetriever.retrieveActiveElement();
            if (this.element == null) {
                return this.activeElement == null;
            }
            return this.activeElement.equals(this.element);
        }
        catch (StaleElementReferenceException e) {
            return false;
        }
    }

    public String toString() {
        String focused = this.activeElement == null ? null : (this.activeElement.getAttribute("id") != null ? this.activeElement.getAttribute("id") : this.activeElement.toString());
        return String.format("waiting for the focus on '%s' failed - last focused element: %s", this.element, focused);
    }
}

