/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.arquillian.browser;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.drone.api.annotation.Default;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.test.spi.TestResult;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;

public class FailureScreenshot {
    private final File screenshotDir = new File("target/screenshots/");

    public void takeScreenshotOnFailure(@Observes(precedence=500) After event, TestResult result) throws IOException {
        if (result.getStatus() == TestResult.Status.FAILED) {
            TakesScreenshot takesScreenshot = (TakesScreenshot)GrapheneContext.getContextFor(Default.class).getWebDriver(new Class[]{TakesScreenshot.class});
            File tempFile = (File)takesScreenshot.getScreenshotAs(OutputType.FILE);
            String screenshotName = event.getTestClass().getJavaClass().getName() + "." + event.getTestMethod().getName();
            this.screenshotDir.mkdirs();
            File screenshotFile = new File(this.screenshotDir, screenshotName + ".png");
            FileUtils.copyFile((File)tempFile, (File)screenshotFile);
        }
    }
}

