/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.arquillian.browser;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.drone.api.annotation.Default;
import org.jboss.arquillian.drone.spi.DroneContext;
import org.jboss.arquillian.drone.spi.event.AfterDroneEnhanced;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.jboss.arquillian.graphene.proxy.Interceptor;
import org.jboss.arquillian.graphene.proxy.InvocationContext;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.richfaces.arquillian.browser.BrowserUtils;
import org.richfaces.arquillian.configuration.FundamentalTestConfiguration;
import org.richfaces.arquillian.configuration.FundamentalTestConfigurationContext;

public class ScreenshotTaker {
    private final Logger log = Logger.getLogger(ScreenshotTaker.class.getName());

    public void registerInterceptor(@Observes AfterDroneEnhanced event, DroneContext ctx) {
        WebDriver browser;
        FundamentalTestConfiguration configuration = FundamentalTestConfigurationContext.getProxy();
        if (configuration.isDebug() && BrowserUtils.isPhantomjs(browser = (WebDriver)event.getInstance())) {
            WebDriver proxy = GrapheneContext.getContextFor(Default.class).getWebDriver(new Class[0]);
            Interceptor interceptor = new Interceptor(){

                public Object intercept(InvocationContext ctx) throws Throwable {
                    Object result = ctx.invoke();
                    if (TakesScreenshot.class != ctx.getMethod().getDeclaringClass()) {
                        try {
                            TakesScreenshot takesScreenshot = (TakesScreenshot)GrapheneContext.getContextFor(Default.class).getWebDriver(new Class[]{TakesScreenshot.class});
                            File tempFile = (File)takesScreenshot.getScreenshotAs(OutputType.FILE);
                            FileUtils.copyFile((File)tempFile, (File)new File("target/screenshot.png"));
                        }
                        catch (Exception e) {
                            ScreenshotTaker.this.log.log(Level.WARNING, String.format("Wasn't able to take screenshot before action '%s'", ctx.getMethod(), e));
                        }
                    }
                    return result;
                }
            };
            ((GrapheneProxyInstance)proxy).registerInterceptor(interceptor);
        }
    }
}

