/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.cache;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.context.FacesContext;
import org.ajax4jsf.cache.Cache;
import org.ajax4jsf.cache.CacheFactory;
import org.ajax4jsf.cache.lru.LRUMapCacheFactory;
import org.ajax4jsf.resource.util.URLToStreamHelper;
import org.richfaces.log.RichfacesLogger;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheManager {
    public static final String CACHE_MANAGER_FACTORY_CLASS = "org.ajax4jsf.cache.CACHE_MANAGER_FACTORY_CLASS";
    private static final String[] DEFAULT_FACTORIES_CHAIN = new String[]{"org.ajax4jsf.cache.JBossCacheCacheFactory", "org.ajax4jsf.cache.EhCacheCacheFactory"};
    private static final String FACTORY_PROPERTY_NAME = "org.ajax4jsf.cache.CacheFactory";
    private static final Logger LOG = RichfacesLogger.CACHE.getLogger();
    private CacheFactory cacheFactory;
    private final Map<String, Cache> caches = new ConcurrentHashMap<String, Cache>(1, 0.75f, 1);

    public Cache getCache(String cacheName) {
        return this.caches.get(cacheName);
    }

    public Cache createCache(FacesContext facesContext, String cacheName, Map<?, ?> env) {
        CacheFactory factory = this.getCacheFactory(env);
        Cache cache = factory.createCache(facesContext, cacheName, env);
        cache.start();
        this.caches.put(cacheName, cache);
        return cache;
    }

    public void destroyCache(String cacheName) {
        Cache cache = this.caches.remove(cacheName);
        cache.stop();
    }

    private CacheFactory getCacheFactory(Map<?, ?> env) {
        String[] factories;
        if (this.cacheFactory != null) {
            return this.cacheFactory;
        }
        String configuredFactoryName = this.findFactory(FACTORY_PROPERTY_NAME, env);
        if (configuredFactoryName != null) {
            LOG.info(MessageFormat.format("Configured to use [{0}] cache factory", configuredFactoryName));
            factories = new String[]{configuredFactoryName};
        } else {
            factories = DEFAULT_FACTORIES_CHAIN;
        }
        ClassLoader loader = this.findClassLoader();
        for (String factoryName : factories) {
            try {
                Class<?> spiClass = Class.forName(factoryName, true, loader);
                this.cacheFactory = (CacheFactory)CacheFactory.class.cast(spiClass.newInstance());
                LOG.info(MessageFormat.format("Selected [{0}]", factoryName));
                break;
            }
            catch (LinkageError iae) {
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.cacheFactory == null) {
            this.cacheFactory = new LRUMapCacheFactory();
            LOG.info("Selected fallback cache factory");
        }
        return this.cacheFactory;
    }

    public Map<String, Cache> getCaches() {
        return this.caches;
    }

    private ClassLoader findClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl;
    }

    private static boolean isEmptyString(String s) {
        return s == null || "".equals(s);
    }

    String findFactory(String factoryId, Map<?, ?> env) {
        String envFactoryClass = (String)env.get(CACHE_MANAGER_FACTORY_CLASS);
        if (!CacheManager.isEmptyString(envFactoryClass)) {
            return envFactoryClass;
        }
        String systemPropertyFactoryClass = CacheManager.searchInSystemProperty(factoryId);
        if (!CacheManager.isEmptyString(systemPropertyFactoryClass)) {
            return systemPropertyFactoryClass;
        }
        String jcacheFactoryClass = CacheManager.searchInJcacheProperties(factoryId);
        if (!CacheManager.isEmptyString(jcacheFactoryClass)) {
            return jcacheFactoryClass;
        }
        String classpathFactoryClass = this.searchInClasspath(factoryId);
        if (!CacheManager.isEmptyString(classpathFactoryClass)) {
            return classpathFactoryClass;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String searchInClasspath(String factoryId) {
        block5: {
            String string;
            ClassLoader cl = this.findClassLoader();
            InputStream is = URLToStreamHelper.urlToStreamSafe((URL)cl.getResource("META-INF/services/" + factoryId));
            if (is == null) break block5;
            BufferedReader r = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            try {
                string = r.readLine();
            }
            catch (Throwable throwable) {
                try {
                    r.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            r.close();
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String searchInJcacheProperties(String factoryId) {
        block6: {
            String string;
            String configFile = System.getProperty("java.home") + File.separator + "lib" + File.separator + "jcache.properties";
            File file = new File(configFile);
            if (!file.exists()) break block6;
            FileInputStream in = new FileInputStream(file);
            try {
                Properties props = new Properties();
                props.load(in);
                string = props.getProperty(factoryId);
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)in).close();
                    throw throwable;
                }
                catch (SecurityException ignore) {
                    break block6;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ((InputStream)in).close();
            return string;
        }
        return null;
    }

    private static String searchInSystemProperty(String factoryId) {
        try {
            return System.getProperty(factoryId);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    public void destroy() {
        if (this.caches.isEmpty()) {
            return;
        }
        for (String cacheName : this.caches.keySet()) {
            this.destroyCache(cacheName);
        }
        if (this.cacheFactory != null) {
            this.cacheFactory.destroy();
        }
    }
}

