/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.cache;

import java.util.Date;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.ajax4jsf.cache.Cache;

public class EhCacheCache
implements Cache {
    private Ehcache cache;
    private boolean preconfiguredCache;

    public EhCacheCache(Ehcache cache, boolean preconfiguredCache) {
        this.cache = cache;
        this.preconfiguredCache = preconfiguredCache;
    }

    public void start() {
        if (!this.preconfiguredCache) {
            this.cache.initialise();
            this.cache.bootstrap();
        }
    }

    public void stop() {
        if (!this.preconfiguredCache) {
            this.cache.dispose();
        }
    }

    public Object get(Object key) {
        Element element = this.cache.get(key);
        if (element != null) {
            return element.getObjectValue();
        }
        return null;
    }

    public void put(Object key, Object value, Date expired) {
        Boolean eternal = null;
        Integer ttl = null;
        if (expired != null) {
            eternal = Boolean.FALSE;
            ttl = (int)(expired.getTime() - System.currentTimeMillis()) / 1000;
        }
        Element element = new Element(key, value, eternal, null, ttl);
        this.cache.putQuiet(element);
    }
}

