/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.cache;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.ajax4jsf.cache.Cache;
import org.ajax4jsf.cache.CacheFactory;
import org.ajax4jsf.cache.JBossCacheCache;
import org.ajax4jsf.context.ContextInitParameters;
import org.ajax4jsf.resource.util.URLToStreamHelper;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.EvictionAlgorithmConfigBase;
import org.jboss.cache.eviction.ExpirationAlgorithmConfig;
import org.richfaces.log.RichfacesLogger;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossCacheCacheFactory
implements CacheFactory {
    private static final Logger LOG = RichfacesLogger.CACHE.getLogger();
    private org.jboss.cache.CacheFactory<String, Object> cacheFactory = new DefaultCacheFactory();

    private void setupMaxSizeEviction(FacesContext facesContext, org.jboss.cache.Cache<String, Object> cache) {
        EvictionAlgorithmConfigBase baseEvicitonConfig;
        EvictionConfig evictionConfig = cache.getConfiguration().getEvictionConfig();
        EvictionAlgorithmConfig evictionAlgorithmConfig = evictionConfig.getDefaultEvictionRegionConfig().getEvictionAlgorithmConfig();
        if (evictionAlgorithmConfig instanceof EvictionAlgorithmConfigBase && (baseEvicitonConfig = (EvictionAlgorithmConfigBase)evictionAlgorithmConfig).getMaxNodes() <= 0) {
            int maxCacheSize = ContextInitParameters.getResourcesCacheSize(facesContext);
            LOG.info(MessageFormat.format("Maximum cache size hasn''t been set, resetting to {0} max items", maxCacheSize));
            baseEvicitonConfig.setMaxNodes(maxCacheSize);
        }
    }

    public Cache createCache(FacesContext facesContext, String cacheName, Map<?, ?> env) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        org.jboss.cache.Cache cache = null;
        URL cacheConfigurationURL = null;
        if (contextClassLoader != null) {
            cacheConfigurationURL = contextClassLoader.getResource("jboss-cache.xml");
        }
        if (cacheConfigurationURL != null) {
            InputStream stream = null;
            try {
                stream = URLToStreamHelper.urlToStream((URL)cacheConfigurationURL);
                cache = this.cacheFactory.createCache(stream);
                this.setupMaxSizeEviction(facesContext, (org.jboss.cache.Cache<String, Object>)cache);
            }
            catch (IOException e) {
                throw new FacesException(e.getLocalizedMessage(), (Throwable)e);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        Configuration configuration = new Configuration();
        EvictionRegionConfig evictionRegionConfig = new EvictionRegionConfig(Fqn.root());
        ExpirationAlgorithmConfig expirationAlgorithm = new ExpirationAlgorithmConfig();
        expirationAlgorithm.setMaxNodes(ContextInitParameters.getResourcesCacheSize(facesContext));
        evictionRegionConfig.setEvictionAlgorithmConfig((EvictionAlgorithmConfig)expirationAlgorithm);
        EvictionConfig evictionConfig = new EvictionConfig(evictionRegionConfig);
        evictionConfig.setWakeupInterval(1000L);
        configuration.setEvictionConfig(evictionConfig);
        cache = this.cacheFactory.createCache(configuration);
        return new JBossCacheCache((org.jboss.cache.Cache<String, Object>)cache);
    }

    public void destroy() {
        this.cacheFactory = null;
    }
}

