/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.cache;

import com.opensymphony.oscache.general.GeneralCacheAdministrator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.faces.context.FacesContext;
import org.ajax4jsf.cache.Cache;
import org.ajax4jsf.cache.CacheFactory;
import org.ajax4jsf.cache.OSCacheCache;
import org.ajax4jsf.context.ContextInitParameters;
import org.ajax4jsf.resource.util.URLToStreamHelper;
import org.richfaces.log.RichfacesLogger;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSCacheCacheFactory
implements CacheFactory {
    private static final Logger LOG = RichfacesLogger.CACHE.getLogger();
    private List<GeneralCacheAdministrator> cacheAdministrators = new ArrayList<GeneralCacheAdministrator>(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties() throws IOException {
        Properties properties = new Properties();
        URL resource = OSCacheCache.class.getResource("oscache.properties");
        if (resource != null) {
            InputStream stream = URLToStreamHelper.urlToStream((URL)resource);
            try {
                properties.load(stream);
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }

    public OSCacheCacheFactory() throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = OSCacheCacheFactory.class.getClassLoader();
        }
        Class.forName(GeneralCacheAdministrator.class.getName(), false, classLoader);
    }

    public Cache createCache(FacesContext facesContext, String cacheName, Map<?, ?> env) {
        Properties cacheProperties = new Properties();
        try {
            cacheProperties.putAll((Map<?, ?>)OSCacheCacheFactory.loadProperties());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            cacheProperties.putAll((Map<?, ?>)OSCacheCacheFactory.loadProperties());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        cacheProperties.putAll(env);
        LOG.info("Creating OSCache cache instance using parameters: " + cacheProperties);
        String property = cacheProperties.getProperty("cache.capacity");
        if (property == null) {
            int maxCacheSize = ContextInitParameters.getResourcesCacheSize(facesContext);
            LOG.info(MessageFormat.format("Maximum cache size hasn''t been set, resetting to {0} max items", maxCacheSize));
            cacheProperties.put("cache.capacity", Integer.toString(maxCacheSize));
        }
        GeneralCacheAdministrator cacheAdministrator = new GeneralCacheAdministrator(cacheProperties);
        this.cacheAdministrators.add(cacheAdministrator);
        return new OSCacheCache(cacheAdministrator.getCache());
    }

    public void destroy() {
        for (GeneralCacheAdministrator cacheAdministrator : this.cacheAdministrators) {
            cacheAdministrator.destroy();
        }
        this.cacheAdministrators = null;
    }
}

