/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.cache.lru;

import java.util.Map;
import javax.faces.context.FacesContext;
import org.ajax4jsf.cache.Cache;
import org.ajax4jsf.cache.CacheFactory;
import org.ajax4jsf.cache.lru.LRUMapCache;
import org.ajax4jsf.context.ContextInitParameters;
import org.richfaces.log.RichfacesLogger;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRUMapCacheFactory
implements CacheFactory {
    public static final String CACHE_SIZE_PARAMETER = "org.ajax4jsf.cache.LRU_MAP_CACHE_SIZE";
    private static final Logger LOG = RichfacesLogger.CACHE.getLogger();

    public Cache createCache(FacesContext facesContext, String cacheName, Map<?, ?> env) {
        LOG.info("Creating LRUMap cache instance using parameters: " + env);
        String size = (String)env.get(CACHE_SIZE_PARAMETER);
        if (size == null || size.length() == 0) {
            size = Integer.toString(ContextInitParameters.getResourcesCacheSize(facesContext));
        }
        int parsedSize = Integer.parseInt(size);
        LOG.info("Creating LRUMap cache instance of " + parsedSize + " items capacity");
        return new LRUMapCache(parsedSize);
    }

    public void destroy() {
    }
}

