/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderkit;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpServletResponse;
import org.ajax4jsf.Messages;
import org.ajax4jsf.component.AjaxClientBehavior;
import org.ajax4jsf.component.AjaxComponent;
import org.ajax4jsf.component.AjaxContainer;
import org.ajax4jsf.component.AjaxLoadBundleComponent;
import org.ajax4jsf.component.AjaxViewRoot;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.renderkit.AJAXDataSerializer;
import org.ajax4jsf.renderkit.AjaxEventOptions;
import org.ajax4jsf.renderkit.HandlersChain;
import org.ajax4jsf.renderkit.IdSplitBuilder;
import org.ajax4jsf.renderkit.RendererUtils;
import org.richfaces.application.ServiceTracker;
import org.richfaces.log.RichfacesLogger;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AjaxRendererUtils {
    public static final String AJAX_ABORT_ATTR = "ignoreDupResponses";
    public static final String AJAX_AREAS_RENDERED = "org.ajax4jsf.areas.rendered";
    public static final String AJAX_DELAY_ATTR = "requestDelay";
    public static final String AJAX_FUNCTION_NAME = "RichFaces.ajax";
    public static final String AJAX_PROCESS_ATTRIBUTE = "process";
    public static final String AJAX_QUEUE_ATTR = "eventsQueue";
    public static final String AJAX_REGIONS_ATTRIBUTE = "reRender";
    public static final String AJAX_SINGLE_ATTR = "ajaxSingle";
    public static final String AJAX_SINGLE_PARAMETER_NAME = "ajaxSingle";
    public static final String ALL = "@all";
    public static final String FORM = "@form";
    public static final String THIS = "@this";
    public static final String REGION = "@region";
    public static final String NONE = "@none";
    public static final Set<String> GLOBAL_META_COMPONENTS = new HashSet<String>(2);
    public static final String LIMITRENDER_ATTR_NAME = "limitRender";
    public static final String ONBEFOREDOMUPDATE_ATTR_NAME = "onbeforedomupdate";
    public static final String ONBEGIN_ATTR_NAME = "onbegin";
    public static final String ONCOMPLETE_ATTR_NAME = "oncomplete";
    public static final String DATA_ATTR_NAME = "data";
    public static final String ONCOMPLETE_CONTENT_ID = "org.ajax4jsf.oncomplete";
    public static final String SIMILARITY_GROUPING_ID_ATTR = "similarityGroupingId";
    public static final String STATUS_ATTR_NAME = "status";
    public static final String VALUE_ATTR = "value";
    public static final String EXTENSION_ID = "org.richfaces.extension";
    public static final String AJAX_COMPONENT_ID_PARAMETER = "org.richfaces.ajax.component";
    public static final String BEHAVIOR_EVENT_PARAMETER = "javax.faces.behavior.event";
    private static final String BEFOREDOMUPDATE_ELEMENT_NAME = "beforedomupdate";
    private static final String COMPLETE_ELEMENT_NAME = "complete";
    private static final String DATA_ELEMENT_NAME = "data";
    private static final RendererUtils RENDERER_UTILS;
    private static final Class<?> OBJECT_ARRAY_CLASS;
    private static final Logger LOG;

    private AjaxRendererUtils() {
    }

    public static StringBuffer buildOnClick(UIComponent uiComponent, FacesContext facesContext) {
        return AjaxRendererUtils.buildOnClick(uiComponent, facesContext, false);
    }

    public static StringBuffer buildOnClick(UIComponent uiComponent, FacesContext facesContext, boolean omitDefaultActionUrl) {
        return AjaxRendererUtils.buildOnEvent(uiComponent, facesContext, "onclick", omitDefaultActionUrl);
    }

    public static StringBuffer buildOnEvent(UIComponent uiComponent, FacesContext facesContext, String eventName) {
        return AjaxRendererUtils.buildOnEvent(uiComponent, facesContext, eventName, false);
    }

    public static StringBuffer buildOnEvent(UIComponent uiComponent, FacesContext facesContext, String eventName, boolean omitDefaultActionUrl) {
        StringBuffer onEvent = new StringBuffer();
        return onEvent;
    }

    public static AjaxEventOptions buildEventOptions(FacesContext facesContext, UIComponent component) {
        return AjaxRendererUtils.buildEventOptions(facesContext, component, null);
    }

    public static AjaxEventOptions buildEventOptions(FacesContext facesContext, UIComponent component, AjaxClientBehavior ajaxBehavior) {
        AjaxEventOptions ajaxEventOptions = new AjaxEventOptions();
        Map<String, Object> parametersMap = RENDERER_UTILS.createParametersMap(facesContext, component);
        String ajaxStatusName = AjaxRendererUtils.getAjaxStatus(component);
        if (ajaxBehavior != null) {
            ajaxStatusName = ajaxBehavior.getStatus() != null ? ajaxBehavior.getStatus() : ajaxStatusName;
            AjaxRendererUtils.appenAjaxBehaviorOptions(ajaxBehavior, ajaxEventOptions);
        } else {
            AjaxRendererUtils.appendComponentOptions(facesContext, component, ajaxEventOptions);
        }
        if (ajaxStatusName != null && ajaxStatusName.length() != 0) {
            ajaxEventOptions.set(STATUS_ATTR_NAME, ajaxStatusName);
        }
        if (!parametersMap.isEmpty()) {
            ajaxEventOptions.getParameters().putAll(parametersMap);
        }
        return ajaxEventOptions;
    }

    private static boolean isNotEmpty(String value) {
        return value != null && value.length() != 0;
    }

    private static void appenAjaxBehaviorOptions(AjaxClientBehavior behavior, AjaxEventOptions ajaxEventOptions) {
        for (BehaviorEventOptionsData optionsData : BehaviorEventOptionsData.values()) {
            String eventHandlerValue = optionsData.getAttributeValue(behavior);
            if (!AjaxRendererUtils.isNotEmpty(eventHandlerValue)) continue;
            ajaxEventOptions.set(optionsData.toString(), eventHandlerValue);
        }
    }

    private static void appendComponentOptions(FacesContext facesContext, UIComponent component, AjaxEventOptions ajaxEventOptions) {
        String behaviorName = "begin";
        HandlersChain handlersChain = new HandlersChain(component);
        String inlineHandler = AjaxRendererUtils.getAjaxOnBegin(component);
        handlersChain.addInlineHandlerAsValue(facesContext, inlineHandler);
        handlersChain.addBehaviors(facesContext, behaviorName);
        String handlerScript = handlersChain.toScript();
        if (AjaxRendererUtils.isNotEmpty(handlerScript)) {
            ajaxEventOptions.set(behaviorName, handlerScript);
        }
        ajaxEventOptions.set("incId", "1");
    }

    public static JSFunction buildAjaxFunction(FacesContext facesContext, UIComponent uiComponent, String functionName) {
        JSFunction ajaxFunction = new JSFunction(functionName, new Object[0]);
        ajaxFunction.addParameter((Object)uiComponent.getClientId(facesContext));
        ajaxFunction.addParameter((Object)JSReference.EVENT);
        return ajaxFunction;
    }

    public static Set<String> getAjaxAreas(UIComponent uiComponent) {
        Object areas = uiComponent instanceof AjaxComponent ? ((AjaxComponent)uiComponent).getReRender() : uiComponent.getAttributes().get(AJAX_REGIONS_ATTRIBUTE);
        return AjaxRendererUtils.asSet(areas);
    }

    public static Set<String> getAjaxAreasToProcess(UIComponent component) {
        Object areas = component instanceof AjaxComponent ? ((AjaxComponent)component).getProcess() : component.getAttributes().get(AJAX_PROCESS_ATTRIBUTE);
        return AjaxRendererUtils.asSet(areas);
    }

    public static String[] asArray(String valuesSet) {
        return IdSplitBuilder.split(valuesSet);
    }

    public static Set<String> asSet(Object valueToSet) {
        if (null != valueToSet) {
            if (valueToSet instanceof Set) {
                return new LinkedHashSet<String>((Set)valueToSet);
            }
            if (valueToSet instanceof Collection) {
                return new LinkedHashSet<String>((Collection)valueToSet);
            }
            if (OBJECT_ARRAY_CLASS.isAssignableFrom(valueToSet.getClass())) {
                return new LinkedHashSet<String>(Arrays.asList((String[])valueToSet));
            }
            if (valueToSet instanceof String) {
                String areasString = ((String)valueToSet).trim();
                if (areasString.contains(",") || areasString.contains(" ")) {
                    String[] values = AjaxRendererUtils.asArray(areasString);
                    LinkedHashSet<String> result = new LinkedHashSet<String>(values.length);
                    for (String value : values) {
                        result.add(value);
                    }
                    return result;
                }
                LinkedHashSet<String> areasSet = new LinkedHashSet<String>(5);
                areasSet.add(areasString);
                return areasSet;
            }
        }
        return null;
    }

    public static String getAjaxStatus(UIComponent component) {
        String statusId = component instanceof AjaxComponent ? ((AjaxComponent)component).getStatus() : (String)component.getAttributes().get(STATUS_ATTR_NAME);
        return statusId;
    }

    public static JSFunctionDefinition buildAjaxOncomplete(String body) {
        JSFunctionDefinition function = new JSFunctionDefinition(new Object[]{"request", "event", "data"});
        function.addToBody((Object)body);
        return function;
    }

    public static JSFunctionDefinition buildAjaxOnBeforeDomUpdate(String body) {
        JSFunctionDefinition function = new JSFunctionDefinition(new Object[]{"request", "event", "data"});
        function.addToBody((Object)body);
        return function;
    }

    public static String getAjaxOncomplete(UIComponent component) {
        if (component instanceof AjaxComponent) {
            return ((AjaxComponent)component).getOncomplete();
        }
        return (String)component.getAttributes().get(ONCOMPLETE_ATTR_NAME);
    }

    public static String getAjaxOnBeforeDomUpdate(UIComponent component) {
        if (component instanceof AjaxComponent) {
            return ((AjaxComponent)component).getOnbeforedomupdate();
        }
        return (String)component.getAttributes().get(ONBEFOREDOMUPDATE_ATTR_NAME);
    }

    public static String getAjaxOnBegin(UIComponent component) {
        if (component instanceof AjaxComponent) {
            return ((AjaxComponent)component).getOnbegin();
        }
        return (String)component.getAttributes().get(ONBEGIN_ATTR_NAME);
    }

    public static Object getAjaxData(UIComponent component) {
        if (component instanceof AjaxComponent) {
            return ((AjaxComponent)component).getData();
        }
        return component.getAttributes().get("data");
    }

    public static boolean isAjaxLimitRender(UIComponent component) {
        boolean result = false;
        if (component instanceof AjaxComponent) {
            result = ((AjaxComponent)component).isLimitRender();
        } else {
            try {
                result = (Boolean)component.getAttributes().get(LIMITRENDER_ATTR_NAME);
            }
            catch (NullPointerException e) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return result;
    }

    public static String getAbsoluteId(UIComponent component) {
        if (component == null) {
            throw new NullPointerException(Messages.getMessage((String)"COMPONENT_NULL_ERROR_2"));
        }
        StringBuffer idBuf = new StringBuffer();
        idBuf.append(component.getId());
        UIComponent parent = component;
        while ((parent = parent.getParent()) != null) {
            if (!(parent instanceof NamingContainer)) continue;
            idBuf.insert(0, ':');
            idBuf.insert(0, parent.getId());
        }
        idBuf.insert(0, ':');
        LOG.debug(Messages.getMessage((String)"CALCULATE_COMPONENT_ID_INFO", (Object)component.getId(), (Object)idBuf.toString()));
        return idBuf.toString();
    }

    public static UIComponent getNestingForm(UIComponent component) {
        UIComponent parent;
        for (parent = component; !(parent == null || parent instanceof UIForm || "org.apache.myfaces.trinidad.Form".equals(parent.getFamily()) || "oracle.adf.Form".equals(parent.getFamily())); parent = parent.getParent()) {
        }
        return parent;
    }

    protected static String getAjaxActionUrl(FacesContext facesContext) {
        return AjaxContext.getCurrentInstance((FacesContext)facesContext).getAjaxActionURL(facesContext);
    }

    public static AjaxContainer findAjaxContainer(FacesContext facesContext, UIComponent uiComponent) {
        UIComponent parent;
        for (parent = uiComponent.getParent(); parent != null && !(parent instanceof AjaxContainer); parent = parent.getParent()) {
        }
        AjaxContainer nestingContainer = null;
        if (parent != null) {
            nestingContainer = (AjaxContainer)parent;
        } else if (facesContext.getViewRoot() instanceof AjaxViewRoot) {
            nestingContainer = (AjaxContainer)facesContext.getViewRoot();
        }
        return nestingContainer;
    }

    public static void encodeAreas(FacesContext context, UIComponent component) throws IOException {
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)context);
        ExternalContext externalContext = context.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        Set rendered = ajaxContext.getAjaxRenderedAreas();
        ResponseWriter out = context.getResponseWriter();
        out.startElement("meta", component);
        out.writeAttribute("name", (Object)"Ajax-Update-Ids", null);
        StringBuffer senderString = new StringBuffer();
        Iterator it = rendered.iterator();
        while (it.hasNext()) {
            String id = (String)it.next();
            senderString.append(id);
            if (!it.hasNext()) continue;
            senderString.append(',');
        }
        out.writeAttribute("content", (Object)senderString, null);
        out.endElement("meta");
        out.startElement("span", component);
        out.writeAttribute("id", (Object)"ajax-view-state", null);
        AjaxRendererUtils.writeState(context);
        out.endElement("span");
        out.startElement("meta", component);
        out.writeAttribute("id", (Object)"Ajax-Response", null);
        out.writeAttribute("name", (Object)"Ajax-Response", null);
        out.writeAttribute("content", (Object)"true", null);
        out.endElement("meta");
        Object response = externalContext.getResponse();
        if (response instanceof HttpServletResponse) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.setHeader("Ajax-Response", "true");
        } else {
            try {
                Method setHeadergMethod = response.getClass().getMethod("setHeader", String.class, String.class);
                setHeadergMethod.invoke(response, "Ajax-Response", "true");
            }
            catch (Exception e) {
                LOG.error(Messages.getMessage((String)"DETECTING_ENCODING_DISABLED_ERROR"));
                LOG.error(Messages.getMessage((String)"OBTAIN_RESPONSE_SET_HEADER_ERROR", (Object)e));
            }
        }
        Map responseDataMap = ajaxContext.getResponseDataMap();
        AJAXDataSerializer serializer = (AJAXDataSerializer)ServiceTracker.getService((FacesContext)context, AJAXDataSerializer.class);
        for (Map.Entry entry : responseDataMap.entrySet()) {
            out.startElement("span", component);
            out.writeAttribute("id", entry.getKey(), null);
            String dataString = serializer.asString(entry.getValue());
            out.write(dataString);
            out.endElement("span");
        }
        Object oncomplete = ajaxContext.getOncomplete();
        if (null != oncomplete) {
            out.startElement("span", component);
            out.writeAttribute("id", (Object)ONCOMPLETE_CONTENT_ID, null);
            out.writeText(oncomplete, null);
            out.endElement("span");
        }
        requestMap.put(AJAX_AREAS_RENDERED, "true");
    }

    public static void writeState(FacesContext context) throws IOException {
        context.getApplication().getViewHandler().writeState(context);
    }

    public static void encodeAjaxBegin(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        out.startElement("html", component);
        Locale locale = context.getViewRoot().getLocale();
        out.writeAttribute("lang", (Object)locale.toString(), "lang");
        out.startElement("body", component);
    }

    public static void encodeAjaxEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        AjaxRendererUtils.encodeAreas(context, component);
        out.endElement("body");
        out.endElement("html");
    }

    public static void loadBundles(FacesContext context) {
        AjaxRendererUtils.loadBundles(context, (UIComponent)context.getViewRoot());
    }

    private static void loadBundles(FacesContext context, UIComponent component) {
        for (UIComponent child : component.getChildren()) {
            AjaxRendererUtils.loadCildBundles(context, child);
        }
        for (UIComponent child : component.getFacets().values()) {
            AjaxRendererUtils.loadCildBundles(context, child);
        }
    }

    private static void loadCildBundles(FacesContext context, UIComponent child) {
        if (child instanceof AjaxLoadBundleComponent) {
            try {
                child.encodeBegin(context);
            }
            catch (IOException iOException) {}
        } else {
            AjaxRendererUtils.loadBundles(context, child);
        }
    }

    public static boolean isAjaxRequest(FacesContext facesContext) {
        return AjaxContext.getCurrentInstance((FacesContext)facesContext).isAjaxRequest();
    }

    public static void addRegionByName(FacesContext facesContext, UIComponent component, String id) {
        AjaxContext.getCurrentInstance((FacesContext)facesContext).addComponentToAjaxRender(component, id);
    }

    public static void addRegionsFromComponent(UIComponent component, FacesContext facesContext) {
        AjaxContext.getCurrentInstance((FacesContext)facesContext).addRegionsFromComponent(component);
    }

    private static void startExtensionElementIfNecessary(PartialResponseWriter partialResponseWriter, Map<String, String> attributes, boolean[] writingState) throws IOException {
        if (!writingState[0]) {
            writingState[0] = true;
            partialResponseWriter.startExtension(attributes);
        }
    }

    private static void endExtensionElementIfNecessary(PartialResponseWriter partialResponseWriter, boolean[] writingState) throws IOException {
        if (writingState[0]) {
            writingState[0] = false;
            partialResponseWriter.endExtension();
        }
    }

    public static void renderAjaxExtensions(FacesContext facesContext, UIComponent component) throws IOException {
        Object responseData;
        Object oncomplete;
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)facesContext);
        Map<String, String> attributes = Collections.singletonMap("id", facesContext.getExternalContext().encodeNamespace(EXTENSION_ID));
        PartialResponseWriter writer = facesContext.getPartialViewContext().getPartialResponseWriter();
        boolean[] writingState = new boolean[]{false};
        Object onbeforedomupdate = ajaxContext.getOnbeforedomupdate();
        if (onbeforedomupdate != null) {
            AjaxRendererUtils.startExtensionElementIfNecessary(writer, attributes, writingState);
            writer.startElement(BEFOREDOMUPDATE_ELEMENT_NAME, component);
            writer.writeText(onbeforedomupdate, null);
            writer.endElement(BEFOREDOMUPDATE_ELEMENT_NAME);
        }
        if ((oncomplete = ajaxContext.getOncomplete()) != null) {
            AjaxRendererUtils.startExtensionElementIfNecessary(writer, attributes, writingState);
            writer.startElement(COMPLETE_ELEMENT_NAME, component);
            writer.writeText(oncomplete, null);
            writer.endElement(COMPLETE_ELEMENT_NAME);
        }
        if ((responseData = ajaxContext.getResponseData()) != null) {
            AjaxRendererUtils.startExtensionElementIfNecessary(writer, attributes, writingState);
            writer.startElement("data", component);
            AJAXDataSerializer serializer = (AJAXDataSerializer)ServiceTracker.getService((FacesContext)facesContext, AJAXDataSerializer.class);
            writer.writeText((Object)serializer.asString(responseData), null);
            writer.endElement("data");
        }
        AjaxRendererUtils.endExtensionElementIfNecessary(writer, writingState);
    }

    static {
        GLOBAL_META_COMPONENTS.add(ALL);
        GLOBAL_META_COMPONENTS.add(NONE);
        RENDERER_UTILS = RendererUtils.getInstance();
        OBJECT_ARRAY_CLASS = new Object[0].getClass();
        LOG = RichfacesLogger.RENDERKIT.getLogger();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BehaviorEventOptionsData {
        begin{

            public String getAttributeValue(AjaxClientBehavior behavior) {
                return behavior.getOnbegin();
            }
        }
        ,
        error{

            public String getAttributeValue(AjaxClientBehavior behavior) {
                return behavior.getOnerror();
            }
        }
        ,
        queueId{

            public String getAttributeValue(AjaxClientBehavior behavior) {
                return behavior.getQueueId();
            }
        }
        ,
        event{

            public String getAttributeValue(AjaxClientBehavior behavior) {
                return behavior.getOnevent();
            }
        };


        public abstract String getAttributeValue(AjaxClientBehavior var1);
    }
}

