/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderkit;

import java.util.Iterator;
import javax.faces.FactoryFinder;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.FacesContext;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import org.ajax4jsf.Messages;
import org.ajax4jsf.renderkit.ChameleonRenderKit;
import org.richfaces.log.RichfacesLogger;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChameleonRenderKitFactory
extends RenderKitFactory {
    private static final Logger LOG = RichfacesLogger.RENDERKIT.getLogger();
    RenderKitFactory defaultFactory;

    public ChameleonRenderKitFactory(RenderKitFactory defaultFactory) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("ChameleonRenderKitFactory(RenderKitFactory) - Chameleon RenderKit factory instantiated");
        }
        this.defaultFactory = defaultFactory;
    }

    public void addRenderKit(String renderKitId, RenderKit renderKit) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("addRenderKit(String, RenderKit) - Added RenderKit with id - renderKitId=" + renderKitId);
        }
        if (renderKit instanceof ChameleonRenderKit) {
            // empty if block
        }
        this.defaultFactory.addRenderKit(renderKitId, renderKit);
    }

    public RenderKit getRenderKit(FacesContext context, String renderKitId) {
        RenderKit renderKit = this.defaultFactory.getRenderKit(context, renderKitId);
        if (renderKit instanceof ChameleonRenderKit) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(Messages.getMessage((String)"REQUEST_CHAMELEON_RENDER_KIT_INFO", (Object)renderKitId));
            }
            String baseRenderKitId = null;
            try {
                if (null != context) {
                    baseRenderKitId = context.getApplication().getDefaultRenderKitId();
                } else {
                    ApplicationFactory appFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
                    baseRenderKitId = appFactory.getApplication().getDefaultRenderKitId();
                }
            }
            catch (Exception e) {
                LOG.warn(Messages.getMessage((String)"GET_DEFAULT_RENDER_KIT_ERROR"), (Throwable)e);
            }
            if (baseRenderKitId == null) {
                baseRenderKitId = "HTML_BASIC";
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(Messages.getMessage((String)"DEFAULT_RENDER_KIT_INFO", (Object)baseRenderKitId));
            }
            ((ChameleonRenderKit)renderKit).setDefaultRenderKit(this.defaultFactory.getRenderKit(context, baseRenderKitId));
        }
        return renderKit;
    }

    public Iterator<String> getRenderKitIds() {
        return this.defaultFactory.getRenderKitIds();
    }
}

