/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ajax4jsf.Messages;
import org.ajax4jsf.cache.Cache;
import org.ajax4jsf.cache.CacheManager;
import org.ajax4jsf.cache.ServletContextInitMap;
import org.ajax4jsf.resource.FacesResourceContext;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.ResourceContext;
import org.ajax4jsf.resource.ResourceLifecycle;
import org.ajax4jsf.resource.ServletResourceContext;
import org.ajax4jsf.resource.util.URLToStreamHelper;
import org.ajax4jsf.webapp.BaseFilter;
import org.ajax4jsf.webapp.WebXml;
import org.richfaces.log.RichfacesLogger;
import org.slf4j.Logger;

public class InternetResourceService {
    static final String ENABLE_CACHING_PARAMETER = "enable-cache";
    private static final String RESOURCE_LIFECYCLE_PARAMETER = "org.ajax4jsf.RESOURCE_LIFECYCLE";
    private static final Logger LOG = RichfacesLogger.RESOURCE.getLogger();
    private Cache cache = null;
    private boolean cacheEnabled = true;
    private FacesContextFactory contextFactory;
    private FilterConfig filterConfig;
    private ResourceLifecycle lifecycle;
    private String lifecycleClass;
    private WebXml webXml;

    public void setCacheEnabled(boolean b) {
        this.cacheEnabled = b;
    }

    public void init(FilterConfig config) throws ServletException {
        this.filterConfig = config;
        ServletContext servletContext = config.getServletContext();
        if ("false".equalsIgnoreCase(config.getInitParameter(ENABLE_CACHING_PARAMETER))) {
            this.setCacheEnabled(false);
        } else {
            CacheManager cacheManager = new CacheManager();
            ServletContextInitMap env = new ServletContextInitMap(servletContext);
            this.cache = cacheManager.createCache(FacesContext.getCurrentInstance(), "org.richfaces.resources", env);
        }
        this.lifecycleClass = servletContext.getInitParameter(RESOURCE_LIFECYCLE_PARAMETER);
        if (this.lifecycleClass != null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> clazz = classLoader.loadClass(this.lifecycleClass);
                this.lifecycle = (ResourceLifecycle)((Object)clazz.newInstance());
            }
            catch (Exception e) {
                throw new FacesException("Error create instance of resource Lifecycle " + this.lifecycleClass, (Throwable)e);
            }
        } else {
            this.lifecycle = new ResourceLifecycle();
        }
        this.webXml = new WebXml();
        this.webXml.init(servletContext, this.filterConfig.getFilterName());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resources service initialized");
        }
    }

    protected ResourceContext getResourceContext(InternetResource resource, HttpServletRequest request, HttpServletResponse response) throws FacesException {
        ResourceContext resourceContext = resource.requireFacesContext() ? new FacesResourceContext(this.getFacesContext((ServletRequest)request, (ServletResponse)response)) : new ServletResourceContext(this.getServletContext(), request, response);
        return resourceContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties getProperties(String name) {
        Properties properties = new Properties();
        InputStream props = URLToStreamHelper.urlToStreamSafe((URL)BaseFilter.class.getResource(name));
        if (null != props) {
            try {
                properties.load(props);
            }
            catch (IOException e) {
                LOG.warn(Messages.getMessage((String)"READING_PROPERTIES_ERROR", (Object)name), (Throwable)e);
            }
            finally {
                try {
                    props.close();
                }
                catch (IOException e) {}
            }
        }
        return properties;
    }

    protected ServletContext getServletContext() {
        return this.filterConfig.getServletContext();
    }

    protected ResourceLifecycle getLifecycle() throws FacesException {
        return this.lifecycle;
    }

    protected synchronized FacesContextFactory getContextFactory() {
        if (this.contextFactory == null) {
            this.contextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
        }
        return this.contextFactory;
    }

    protected FacesContext getFacesContext(ServletRequest request, ServletResponse response) throws FacesException {
        return this.getContextFactory().getFacesContext((Object)this.getServletContext(), (Object)request, (Object)response, (Lifecycle)this.getLifecycle());
    }
}

