/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.resource;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import javax.faces.context.FacesContext;
import javax.imageio.ImageIO;
import org.ajax4jsf.util.HtmlColor;
import org.ajax4jsf.util.HtmlDimensions;
import org.richfaces.resource.AbstractCacheableResource;
import org.richfaces.resource.ImageType;
import org.richfaces.resource.StateHolderResource;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;

public abstract class Java2Dresource
extends AbstractCacheableResource
implements StateHolderResource {
    private static final String SKIN_MARKER = "Skin.";
    private ImageType imageType;

    public Java2Dresource(ImageType imageType) {
        this.imageType = imageType;
    }

    public abstract Dimension getDimension();

    protected void paint(Graphics2D graphics2D, Dimension dimension) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws IOException {
        Dimension dimension = this.getDimension();
        int width = dimension.width;
        int height = dimension.height;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (width > 0 && height > 0) {
            BufferedImage image = this.imageType.createImage(width, height);
            Graphics2D g2d = image.createGraphics();
            try {
                this.paint(g2d, dimension);
            }
            finally {
                g2d.dispose();
            }
            try {
                ImageIO.write((RenderedImage)image, this.imageType.getFormatName(), baos);
            }
            finally {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public String getContentType() {
        return this.imageType.getMimeType();
    }

    protected String getValueParameter(FacesContext context, String name) {
        SkinFactory skinFactory = SkinFactory.getInstance();
        Skin skin = skinFactory.getSkin(context);
        String value = (String)skin.getParameter(context, name);
        if (value == null || value.length() == 0) {
            skin = skinFactory.getDefaultSkin(context);
            value = (String)skin.getParameter(context, name);
        }
        return value;
    }

    protected String encodeSkinParameter(String param) {
        if (param.startsWith(SKIN_MARKER)) {
            String name = param.substring(SKIN_MARKER.length());
            return this.getValueParameter(FacesContext.getCurrentInstance(), name);
        }
        return param;
    }

    protected Integer getColorValueParameter(FacesContext context, String name, boolean useDefault) {
        Skin skin = useDefault ? SkinFactory.getInstance().getDefaultSkin(context) : SkinFactory.getInstance().getSkin(context);
        return this.decodeColor((String)skin.getParameter(context, name));
    }

    protected Integer getHeight(FacesContext context, String heightParamName) {
        SkinFactory skinFactory = SkinFactory.getInstance();
        Skin skin = skinFactory.getSkin(context);
        String height = (String)skin.getParameter(context, heightParamName);
        if (height == null || height.length() == 0) {
            skin = skinFactory.getDefaultSkin(context);
            height = (String)skin.getParameter(context, heightParamName);
        }
        if (height != null && height.length() != 0) {
            return HtmlDimensions.decode(height).intValue();
        }
        return 16;
    }

    protected Integer decodeColor(String value) {
        if (value != null && value.length() != 0) {
            return HtmlColor.decode(value).getRGB();
        }
        return null;
    }

    public void readState(FacesContext context, DataInput dataInput) throws IOException {
    }

    public void writeState(FacesContext context, DataOutput dataOutput) throws IOException {
    }

    public boolean isTransient() {
        return false;
    }
}

