/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.webapp;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;

final class ServletStreamWriter
extends ServletOutputStream {
    private byte[] buff = new byte[1024];
    private int point = 0;
    private String charset;
    private PrintWriter writer;

    public ServletStreamWriter(PrintWriter writer) {
        this.writer = writer;
    }

    public ServletStreamWriter(PrintWriter writer, String charset) {
        this.writer = writer;
        this.charset = charset;
    }

    public void write(int b) throws IOException {
        this.buff[this.point++] = (byte)b;
        if (this.point == this.buff.length) {
            this.point = 0;
            String string = null == this.charset ? new String(this.buff) : new String(this.buff, this.charset);
            this.writer.write(string);
        }
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void close() throws IOException {
        this.flush();
        super.close();
    }

    public void flush() throws IOException {
        if (this.point > 0) {
            String string = null == this.charset ? new String(this.buff, 0, this.point) : new String(this.buff, 0, this.point, this.charset);
            this.writer.write(string);
            this.point = 0;
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.flush();
        String string = null == this.charset ? new String(b, off, len) : new String(b, off, len, this.charset);
        this.writer.write(string);
    }
}

