/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.application;

import java.text.MessageFormat;
import java.util.ArrayList;
import javax.faces.FacesException;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PostConstructApplicationEvent;
import javax.faces.event.PreDestroyApplicationEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.richfaces.VersionBean;
import org.richfaces.application.DefaultModule;
import org.richfaces.application.Module;
import org.richfaces.application.ServiceException;
import org.richfaces.application.ServiceLoader;
import org.richfaces.application.ServiceTracker;
import org.richfaces.application.ServicesFactory;
import org.richfaces.application.ServicesFactoryImpl;
import org.richfaces.log.RichfacesLogger;
import org.slf4j.Logger;

public class InitializationListener
implements SystemEventListener {
    private static final Logger LOGGER = RichfacesLogger.APPLICATION.getLogger();

    public boolean isListenerForSource(Object source) {
        return true;
    }

    protected void onStart() {
        String versionString;
        ServicesFactory injector = this.createFactory();
        ServiceTracker.setFactory((ServicesFactory)injector);
        if (LOGGER.isInfoEnabled() && (versionString = VersionBean.VERSION.toString()) != null && versionString.length() != 0) {
            LOGGER.info(versionString);
        }
    }

    protected ServicesFactory createFactory() {
        ServicesFactoryImpl injector = new ServicesFactoryImpl();
        ArrayList<Module> modules = new ArrayList<Module>();
        modules.add(new DefaultModule());
        try {
            modules.addAll(ServiceLoader.loadServices(Module.class));
            injector.init(modules);
        }
        catch (ServiceException e) {
            throw new FacesException((Throwable)e);
        }
        return injector;
    }

    protected void onStop() {
        ServiceTracker.release();
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        if (event instanceof PostConstructApplicationEvent) {
            this.onStart();
        } else if (event instanceof PreDestroyApplicationEvent) {
            this.onStop();
        } else {
            throw new IllegalArgumentException(MessageFormat.format("Event {0} is not supported!", event));
        }
    }
}

