/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.context;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import org.ajax4jsf.component.AjaxClientBehavior;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.RendererUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ComponentCallback
implements VisitCallback {
    private Collection<String> componentIds = new LinkedHashSet<String>();
    private final String behaviorEvent;
    private final String defaultIdAttribute;

    ComponentCallback(String behaviorEvent, String defaultIdAttribute) {
        this.behaviorEvent = behaviorEvent;
        this.defaultIdAttribute = defaultIdAttribute;
    }

    protected String getDefaultComponentId() {
        return null;
    }

    private AjaxClientBehavior findBehavior(UIComponent target) {
        if (this.behaviorEvent == null || !(target instanceof ClientBehaviorHolder)) {
            return null;
        }
        ClientBehaviorHolder behaviorHolder = (ClientBehaviorHolder)target;
        List behaviors = (List)behaviorHolder.getClientBehaviors().get(this.behaviorEvent);
        if (behaviors == null) {
            return null;
        }
        for (ClientBehavior behavior : behaviors) {
            if (!(behavior instanceof AjaxClientBehavior) || ((AjaxClientBehavior)behavior).isDisabled()) continue;
            return (AjaxClientBehavior)behavior;
        }
        return null;
    }

    protected abstract Object getBehaviorAttributeValue(AjaxClientBehavior var1);

    protected abstract Object getAttributeValue(UIComponent var1);

    protected void doVisit(FacesContext context, UIComponent target, AjaxClientBehavior behavior) {
        Object attributeObject = behavior == null ? this.getAttributeValue(target) : this.getBehaviorAttributeValue(behavior);
        Set<String> attributeIds = AjaxRendererUtils.asSet(attributeObject);
        if (attributeIds == null) {
            attributeIds = new LinkedHashSet<String>();
        }
        if (attributeIds.isEmpty() && this.defaultIdAttribute != null) {
            attributeIds.add(this.defaultIdAttribute);
        }
        this.componentIds.addAll(RendererUtils.getInstance().findComponentsFor(context, target, attributeIds));
    }

    public final VisitResult visit(VisitContext visitContext, UIComponent target) {
        AjaxClientBehavior ajaxBehavior = null;
        if (this.behaviorEvent != null) {
            ajaxBehavior = this.findBehavior(target);
        }
        this.doVisit(visitContext.getFacesContext(), target, ajaxBehavior);
        return VisitResult.COMPLETE;
    }

    public Collection<String> getComponentIds() {
        return this.componentIds;
    }
}

