/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.context;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ComponentMatcherNode {
    private boolean added;
    private boolean patternNode;
    private String source;
    private boolean hasParentPatternNode;
    private int kidPatternNodesCounter = 0;
    private ComponentMatcherNode parentNode;
    private Map<String, ComponentMatcherNode> idChildren;
    private Map<String, ComponentMatcherNode> patternChildren;
    private Set<String> subtreeIds;

    ComponentMatcherNode() {
    }

    private static boolean isEmpty(Collection<?> c) {
        return c == null || c.isEmpty();
    }

    private static boolean isEmpty(Map<?, ?> m) {
        return m == null || m.isEmpty();
    }

    void setParentNode(ComponentMatcherNode parentNode) {
        this.parentNode = parentNode;
    }

    void incrementKidPatternNodesCounter() {
        ComponentMatcherNode parentNode;
        if (this.kidPatternNodesCounter == 0 && !this.isPatternNode() && (parentNode = this.getParentNode()) != null) {
            parentNode.incrementKidPatternNodesCounter();
        }
        ++this.kidPatternNodesCounter;
    }

    void decrementKidPatternNodesCounter() {
        ComponentMatcherNode parentNode;
        --this.kidPatternNodesCounter;
        if (this.kidPatternNodesCounter == 0 && !this.isPatternNode() && (parentNode = this.getParentNode()) != null) {
            parentNode.decrementKidPatternNodesCounter();
        }
    }

    void setHasParentPatternNode(boolean hasParentPatternNode) {
        this.hasParentPatternNode = hasParentPatternNode;
        if (!this.isPatternNode()) {
            if (this.idChildren != null) {
                for (ComponentMatcherNode child : this.idChildren.values()) {
                    child.setHasParentPatternNode(hasParentPatternNode);
                }
            }
            if (this.patternChildren != null) {
                for (ComponentMatcherNode child : this.patternChildren.values()) {
                    child.setHasParentPatternNode(hasParentPatternNode);
                }
            }
        }
    }

    boolean matches(String shortId) {
        if (this.isPatternNode()) {
            return true;
        }
        return this.source.equals(shortId);
    }

    Map<String, ComponentMatcherNode> getChildrenMap(boolean isPattern) {
        return isPattern ? this.patternChildren : this.idChildren;
    }

    Map<String, ComponentMatcherNode> getOrCreateChildrenMap(boolean isPattern) {
        if (isPattern) {
            if (this.patternChildren == null) {
                this.patternChildren = new HashMap<String, ComponentMatcherNode>(1);
            }
            return this.patternChildren;
        }
        if (this.idChildren == null) {
            this.idChildren = new HashMap<String, ComponentMatcherNode>();
        }
        return this.idChildren;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public ComponentMatcherNode getParentNode() {
        return this.parentNode;
    }

    public ComponentMatcherNode getMatchedChild(String shortId) {
        ComponentMatcherNode node = null;
        if (this.idChildren != null) {
            node = this.idChildren.get(shortId);
        }
        if (node == null && this.patternChildren != null) {
            for (ComponentMatcherNode child : this.patternChildren.values()) {
                if (!child.matches(shortId)) continue;
                node = child;
                break;
            }
        }
        return node;
    }

    public ComponentMatcherNode getChild(String key, boolean isPatternNode) {
        Map<String, ComponentMatcherNode> childrenMap = this.getChildrenMap(isPatternNode);
        if (childrenMap != null) {
            return childrenMap.get(key);
        }
        return null;
    }

    public ComponentMatcherNode getOrCreateChild(String key, boolean isPatternNode) {
        Map<String, ComponentMatcherNode> childrenMap = this.getOrCreateChildrenMap(isPatternNode);
        ComponentMatcherNode childNode = childrenMap.get(key);
        if (childNode == null) {
            childNode = new ComponentMatcherNode();
            childNode.setPatternNode(isPatternNode);
            childNode.setSource(key);
            this.addChild(childNode);
        }
        return childNode;
    }

    public void addChild(ComponentMatcherNode child) {
        child.setParentNode(this);
        Map<String, ComponentMatcherNode> childrenMap = this.getOrCreateChildrenMap(child.isPatternNode());
        ComponentMatcherNode previousNode = childrenMap.get(child.getSource());
        if (previousNode != null) {
            this.removeChild(previousNode);
        }
        childrenMap.put(child.getSource(), child);
        if (child.isPatternNode() || child.hasKidPatternNodes()) {
            this.incrementKidPatternNodesCounter();
        }
        if (this.hasPatternNodeInChain()) {
            child.setHasParentPatternNode(true);
        }
        this.addAllSubtreeIds(child.getSubtreeIds());
    }

    public void removeChild(ComponentMatcherNode child) {
        Map<String, ComponentMatcherNode> childrenMap = this.getChildrenMap(child.isPatternNode());
        if (childrenMap != null && child.getParentNode() == this) {
            child.setParentNode(null);
            child.setHasParentPatternNode(false);
            childrenMap.remove(child.getSource());
            if (child.isPatternNode() || child.hasKidPatternNodes()) {
                this.decrementKidPatternNodesCounter();
            }
            this.removeAllSubtreeIds(child.getSubtreeIds());
        }
    }

    public boolean hasDirectChildren() {
        return this.hasDirectIdChildren() || this.hasDirectPatternChildren();
    }

    public boolean hasDirectIdChildren() {
        return !ComponentMatcherNode.isEmpty(this.idChildren);
    }

    public boolean hasDirectPatternChildren() {
        return !ComponentMatcherNode.isEmpty(this.patternChildren);
    }

    public boolean hasKidPatternNodes() {
        return this.kidPatternNodesCounter > 0;
    }

    public void markAdded() {
        this.added = true;
    }

    public void markRemoved() {
        this.added = false;
    }

    public boolean isAdded() {
        return this.added;
    }

    public boolean hasParentPatternNode() {
        return this.hasParentPatternNode;
    }

    public boolean hasPatternNodeInChain() {
        return this.isPatternNode() || this.hasParentPatternNode();
    }

    public Collection<String> getSubtreeIds() {
        return this.subtreeIds;
    }

    public boolean hasSubtreeIds() {
        return !ComponentMatcherNode.isEmpty(this.subtreeIds);
    }

    public void addAllSubtreeIds(Collection<String> ids) {
        if (ids != null) {
            if (this.subtreeIds == null) {
                this.subtreeIds = new HashSet<String>();
            }
            this.subtreeIds.addAll(ids);
            if (this.parentNode != null) {
                this.parentNode.addAllSubtreeIds(ids);
            }
        }
    }

    public void addSubtreeId(String subtreeId) {
        if (this.subtreeIds == null) {
            this.subtreeIds = new HashSet<String>();
        }
        this.subtreeIds.add(subtreeId);
        if (this.parentNode != null) {
            this.parentNode.addSubtreeId(subtreeId);
        }
    }

    public void removeAllSubtreeIds(Collection<String> ids) {
        if (ids != null) {
            if (this.subtreeIds != null) {
                this.subtreeIds.removeAll(ids);
            }
            if (this.parentNode != null) {
                this.parentNode.removeAllSubtreeIds(ids);
            }
        }
    }

    public void removeSubtreeId(String subtreeId) {
        if (this.subtreeIds != null) {
            this.subtreeIds.remove(subtreeId);
        }
        if (this.parentNode != null) {
            this.parentNode.removeSubtreeId(subtreeId);
        }
    }

    public Map<String, ComponentMatcherNode> getIdChildren() {
        return this.idChildren;
    }

    public Map<String, ComponentMatcherNode> getPatternChildren() {
        return this.patternChildren;
    }

    public boolean isPatternNode() {
        return this.patternNode;
    }

    public void setPatternNode(boolean patternNode) {
        this.patternNode = patternNode;
    }
}

