/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.context;

final class IdParser {
    private String id;
    private String componentId;
    private String metadataComponentId;
    private int idx;
    private final char namingContainerSeparator;
    private final char subComponentSeparator;

    public IdParser(char namingContainerSeparator, char subComponentSeparator) {
        this.namingContainerSeparator = namingContainerSeparator;
        this.subComponentSeparator = subComponentSeparator;
    }

    private void reset() {
        this.id = null;
        this.componentId = null;
        this.metadataComponentId = null;
        this.idx = 0;
    }

    public void setId(String id) {
        this.reset();
        this.id = id;
    }

    public boolean findNext() {
        this.componentId = null;
        this.metadataComponentId = null;
        if (this.id == null) {
            return false;
        }
        int idLength = this.id.length();
        if (this.idx < idLength) {
            boolean foundSeparator = false;
            for (int i = this.idx; i < idLength && !foundSeparator; ++i) {
                char c = this.id.charAt(i);
                if (c == this.subComponentSeparator) {
                    if (this.componentId != null) continue;
                    this.componentId = this.id.substring(this.idx, i);
                    this.idx = i;
                    continue;
                }
                if (c != this.namingContainerSeparator) continue;
                String idSegment = this.id.substring(this.idx, i);
                if (this.componentId == null) {
                    this.componentId = idSegment;
                } else {
                    this.metadataComponentId = idSegment;
                }
                this.idx = i + 1;
                foundSeparator = true;
            }
            if (!foundSeparator) {
                String idSegment = this.id.substring(this.idx, idLength);
                if (this.componentId == null) {
                    this.componentId = idSegment;
                } else {
                    this.metadataComponentId = idSegment;
                }
                this.idx = idLength;
            }
            return true;
        }
        this.reset();
        return false;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public String getMetadataComponentId() {
        return this.metadataComponentId;
    }
}

