/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.context;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.PartialViewContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.richfaces.component.MetaComponentEncoder;
import org.richfaces.context.ExecuteComponentCallback;
import org.richfaces.context.ExtendedPartialVisitContext;
import org.richfaces.context.PartialViewContextAjaxOutputTracker;
import org.richfaces.context.RenderComponentCallback;
import org.richfaces.log.RichfacesLogger;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartialViewContextImpl
extends PartialViewContext {
    private static final Logger LOG = RichfacesLogger.CONTEXT.getLogger();
    private static final String ORIGINAL_WRITER = "org.richfaces.PartialViewContextImpl.ORIGINAL_WRITER";
    private ContextMode contextMode = null;
    private FacesContext facesContext;
    private Collection<String> executeIds = null;
    private Collection<String> renderIds = null;
    private Boolean renderAll = null;
    private String activatorComponentId = null;
    private String behaviorEvent = null;
    private boolean released = false;
    private boolean limitRender = false;
    private PartialViewContext wrappedViewContext;

    public PartialViewContextImpl(PartialViewContext wrappedViewContext, FacesContext facesContext) {
        this.wrappedViewContext = wrappedViewContext;
        this.facesContext = facesContext;
    }

    public Collection<String> getExecuteIds() {
        this.assertNotReleased();
        if (this.detectContextMode() == ContextMode.DIRECT) {
            if (this.executeIds == null) {
                this.executeIds = new LinkedHashSet<String>();
                this.setupExecuteIds(this.executeIds);
            }
            return this.executeIds;
        }
        return this.wrappedViewContext.getExecuteIds();
    }

    public Collection<String> getRenderIds() {
        this.assertNotReleased();
        if (this.detectContextMode() == ContextMode.DIRECT) {
            if (this.renderIds == null) {
                this.renderIds = new LinkedHashSet<String>();
            }
            return this.renderIds;
        }
        return this.wrappedViewContext.getRenderIds();
    }

    public boolean isAjaxRequest() {
        this.assertNotReleased();
        return this.wrappedViewContext.isAjaxRequest();
    }

    public boolean isPartialRequest() {
        this.assertNotReleased();
        return this.wrappedViewContext.isPartialRequest();
    }

    public void setPartialRequest(boolean isPartialRequest) {
        this.assertNotReleased();
        this.wrappedViewContext.setPartialRequest(isPartialRequest);
    }

    public boolean isExecuteAll() {
        this.assertNotReleased();
        if (this.detectContextMode() == ContextMode.DIRECT) {
            return this.getExecuteIds().contains("@all");
        }
        return this.wrappedViewContext.isExecuteAll();
    }

    public boolean isRenderAll() {
        this.assertNotReleased();
        if (this.detectContextMode() == ContextMode.DIRECT) {
            if (this.renderAll != null) {
                return this.renderAll;
            }
            return this.getRenderIds().contains("@all");
        }
        return this.wrappedViewContext.isRenderAll();
    }

    public void setRenderAll(boolean isRenderAll) {
        this.assertNotReleased();
        if (this.detectContextMode() == ContextMode.DIRECT) {
            this.renderAll = isRenderAll;
        } else {
            this.wrappedViewContext.setRenderAll(isRenderAll);
        }
    }

    public PartialResponseWriter getPartialResponseWriter() {
        return this.wrappedViewContext.getPartialResponseWriter();
    }

    public void processPartial(PhaseId phaseId) {
        if (this.detectContextMode() == ContextMode.DIRECT && phaseId == PhaseId.RENDER_RESPONSE) {
            this.processPartialRenderPhase();
        } else {
            this.wrappedViewContext.processPartial(phaseId);
        }
    }

    protected void processPartialRenderPhase() {
        PartialViewContext pvc = this.facesContext.getPartialViewContext();
        UIViewRoot viewRoot = this.facesContext.getViewRoot();
        Collection phaseIds = pvc.getRenderIds();
        this.setupRenderIds(phaseIds);
        try {
            PartialResponseWriter writer = pvc.getPartialResponseWriter();
            ResponseWriter orig = this.facesContext.getResponseWriter();
            this.facesContext.getAttributes().put(ORIGINAL_WRITER, orig);
            this.facesContext.setResponseWriter((ResponseWriter)writer);
            ExternalContext exContext = this.facesContext.getExternalContext();
            exContext.setResponseContentType("text/xml");
            exContext.addResponseHeader("Cache-Control", "no-cache");
            writer.startDocument();
            if (this.isRenderAll()) {
                this.renderAll(this.facesContext, viewRoot);
                this.renderState(this.facesContext);
                writer.endDocument();
                return;
            }
            if (phaseIds != null && !phaseIds.isEmpty() || !this.limitRender && PartialViewContextAjaxOutputTracker.hasNestedAjaxOutputs((UIComponent)viewRoot)) {
                EnumSet<VisitHint> hints = EnumSet.of(VisitHint.SKIP_UNRENDERED);
                ExtendedPartialVisitContext visitContext = new ExtendedPartialVisitContext(this.facesContext, phaseIds, hints, this.limitRender);
                RenderVisitCallback visitCallback = new RenderVisitCallback(this.facesContext);
                viewRoot.visitTree((VisitContext)visitContext, (VisitCallback)visitCallback);
            }
            this.renderState(this.facesContext);
            this.renderExtensions(this.facesContext, (UIComponent)viewRoot);
            writer.endDocument();
        }
        catch (IOException ex) {
            this.cleanupAfterView();
            ex.printStackTrace();
        }
        catch (RuntimeException ex) {
            this.cleanupAfterView();
            throw ex;
        }
    }

    private void setupExecuteIds(Collection<String> ids) {
        ExecuteComponentCallback callback = new ExecuteComponentCallback(this.behaviorEvent);
        if (this.visitActivatorComponent(this.activatorComponentId, callback)) {
            ids.addAll(callback.getComponentIds());
            if (!ids.contains("@all")) {
                this.addImplicitExecuteIds(ids);
            }
        }
    }

    private void setupRenderIds(Collection<String> ids) {
        RenderComponentCallback callback;
        if (!this.isRenderAll() && this.visitActivatorComponent(this.activatorComponentId, callback = new RenderComponentCallback(this.behaviorEvent))) {
            ids.addAll(callback.getComponentIds());
            this.limitRender = callback.isLimitRender();
            if (!Boolean.TRUE.equals(this.renderAll) && !ids.contains("@all")) {
                this.addImplicitRenderIds(ids, this.limitRender);
                AjaxContext ajaxContext = AjaxContext.getCurrentInstance();
                ajaxContext.setOnbeforedomupdate((Object)callback.getOnbeforedomupdate());
                ajaxContext.appendOncomplete((Object)callback.getOncomplete());
                ajaxContext.setResponseData(callback.getData());
            }
        }
    }

    private void renderAll(FacesContext context, UIViewRoot viewRoot) throws IOException {
        PartialViewContext pvc = context.getPartialViewContext();
        PartialResponseWriter writer = pvc.getPartialResponseWriter();
        writer.startUpdate("javax.faces.ViewRoot");
        if (viewRoot.getChildCount() > 0) {
            for (UIComponent child : viewRoot.getChildren()) {
                child.encodeAll(context);
            }
        }
        writer.endUpdate();
    }

    private void renderState(FacesContext context) throws IOException {
        if (!context.getViewRoot().isTransient()) {
            PartialViewContext pvc = context.getPartialViewContext();
            PartialResponseWriter writer = pvc.getPartialResponseWriter();
            writer.startUpdate("javax.faces.ViewState");
            String state = context.getApplication().getStateManager().getViewState(context);
            writer.write(state);
            writer.endUpdate();
        }
    }

    public void release() {
        this.assertNotReleased();
        this.released = true;
        this.wrappedViewContext.release();
        this.wrappedViewContext = null;
        this.facesContext = null;
        this.renderAll = null;
        this.executeIds = null;
        this.renderIds = null;
        this.limitRender = false;
        this.activatorComponentId = null;
        this.behaviorEvent = null;
        this.contextMode = null;
    }

    protected void addImplicitExecuteIds(Collection<String> ids) {
        UIViewRoot root;
        if (!ids.isEmpty() && (root = this.facesContext.getViewRoot()).getFacetCount() > 0 && root.getFacet("javax_faces_metadata") != null) {
            ids.add("javax_faces_metadata");
        }
    }

    protected void addImplicitRenderIds(Collection<String> ids, boolean limitRender) {
    }

    protected void renderExtensions(FacesContext context, UIComponent component) throws IOException {
        AjaxRendererUtils.renderAjaxExtensions(context, component);
    }

    private void assertNotReleased() {
        if (this.released) {
            throw new IllegalStateException("PartialViewContext already released!");
        }
    }

    private boolean visitActivatorComponent(String componentActivatorId, VisitCallback visitCallback) {
        Set<String> idsToVisit = Collections.singleton(componentActivatorId);
        EnumSet<VisitHint> visitHints = EnumSet.of(VisitHint.SKIP_UNRENDERED);
        VisitContext visitContext = VisitContext.createVisitContext((FacesContext)this.facesContext, idsToVisit, visitHints);
        boolean visitResult = this.facesContext.getViewRoot().visitTree(visitContext, visitCallback);
        return visitResult;
    }

    private void cleanupAfterView() {
        ResponseWriter orig = (ResponseWriter)this.facesContext.getAttributes().get(ORIGINAL_WRITER);
        assert (null != orig);
        this.facesContext.setResponseWriter(orig);
    }

    protected ContextMode detectContextMode() {
        if (this.contextMode == null) {
            Map requestParameterMap = this.facesContext.getExternalContext().getRequestParameterMap();
            this.activatorComponentId = (String)requestParameterMap.get("org.richfaces.ajax.component");
            if (this.activatorComponentId != null) {
                this.contextMode = ContextMode.DIRECT;
                this.behaviorEvent = (String)requestParameterMap.get("javax.faces.behavior.event");
            } else {
                this.contextMode = ContextMode.WRAPPED;
            }
        }
        return this.contextMode;
    }

    private static final class RenderVisitCallback
    implements VisitCallback {
        private FacesContext ctx;

        private RenderVisitCallback(FacesContext ctx) {
            this.ctx = ctx;
        }

        private void logException(Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error(e.getMessage());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(e.getMessage(), (Throwable)e);
            }
        }

        public VisitResult visit(VisitContext context, UIComponent target) {
            String metaComponentId = (String)this.ctx.getAttributes().get("org.richfaces.MetaComponentId");
            if (metaComponentId != null) {
                MetaComponentEncoder encoder = (MetaComponentEncoder)target;
                try {
                    encoder.encodeMetaComponent(this.ctx, metaComponentId);
                }
                catch (Exception e) {
                    this.logException(e);
                }
            } else {
                PartialResponseWriter writer = this.ctx.getPartialViewContext().getPartialResponseWriter();
                try {
                    writer.startUpdate(target.getClientId(this.ctx));
                    try {
                        target.encodeAll(this.ctx);
                    }
                    catch (Exception ce) {
                        this.logException(ce);
                    }
                    writer.endUpdate();
                }
                catch (IOException e) {
                    this.logException(e);
                }
            }
            return VisitResult.REJECT;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ContextMode {
        WRAPPED,
        DIRECT;

    }
}

