/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import org.richfaces.component.UISequence;
import org.richfaces.component.util.HtmlUtil;

public class SequenceRendererHelper {
    private UISequence sequence;
    private int rowIndex = -1;
    private int columnIndex = 0;
    private String[] rowClasses = null;
    private String[] columnClasses = null;

    private static String[] splitClassesString(String s) {
        if (s != null) {
            return s.split(",");
        }
        return null;
    }

    private static String getCorrespondingArrayItem(String[] strings, int idx) {
        if (strings != null && strings.length > 0) {
            return strings[idx % strings.length];
        }
        return null;
    }

    public SequenceRendererHelper(UISequence sequence) {
        this.sequence = sequence;
        this.rowClasses = SequenceRendererHelper.splitClassesString((String)sequence.getAttributes().get("rowClasses"));
        this.columnClasses = SequenceRendererHelper.splitClassesString((String)sequence.getAttributes().get("columnClasses"));
    }

    public UISequence getSequence() {
        return this.sequence;
    }

    private void initialize() {
        this.rowIndex = this.sequence.getRowIndex();
    }

    public void nextRow() {
        if (this.rowIndex == -1) {
            this.initialize();
        }
        ++this.rowIndex;
        this.columnIndex = 0;
    }

    public void nextColumn() {
        ++this.columnIndex;
    }

    public String getRowClass() {
        String rowClass = (String)this.sequence.getAttributes().get("rowClass");
        return HtmlUtil.concatClasses(SequenceRendererHelper.getCorrespondingArrayItem(this.rowClasses, this.rowIndex), rowClass);
    }

    public String getColumnClass() {
        return SequenceRendererHelper.getCorrespondingArrayItem(this.columnClasses, this.columnIndex);
    }

    public boolean hasWalkedOverRows() {
        return this.rowIndex != -1;
    }
}

