/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import org.richfaces.resource.TestResource2;
import org.w3c.dom.Node;

public class AnimatedTestResource
extends TestResource2 {
    private static final int DELAY_TIME = 50;
    private static final int FRAMES_COUNT = 10;

    private static ImageWriter getImageWriter() {
        ImageWriter result = null;
        Iterator<ImageWriter> imageWriters = ImageIO.getImageWritersByFormatName("gif");
        while (imageWriters.hasNext() && result == null) {
            ImageWriter imageWriter = imageWriters.next();
            if (!imageWriter.canWriteSequence()) continue;
            result = imageWriter;
        }
        return result;
    }

    private static Node getOrCreateChild(Node root, String name) {
        Node result = null;
        for (Node node = root.getFirstChild(); node != null && result == null; node = node.getNextSibling()) {
            if (!name.equals(node.getNodeName())) continue;
            result = node;
        }
        if (result == null) {
            result = new IIOMetadataNode(name);
            root.appendChild(result);
        }
        return result;
    }

    public String getContentType() {
        return "image/gif";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws IOException {
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Dimension dimension = this.getDimension();
        BufferedImage image = new BufferedImage(dimension.width, dimension.height, 5);
        Graphics2D g2d = environment.createGraphics(image);
        ImageWriter sequenceCapableImageWriter = AnimatedTestResource.getImageWriter();
        if (sequenceCapableImageWriter == null) {
            throw new IllegalStateException("No sequence-capable image writers exit");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageOutputStream imageOutputStream = null;
        try {
            imageOutputStream = ImageIO.createImageOutputStream(baos);
            sequenceCapableImageWriter.setOutput(imageOutputStream);
            ImageWriteParam defaultImageWriteParam = sequenceCapableImageWriter.getDefaultWriteParam();
            ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(image.getType());
            IIOMetadata imageMetaData = sequenceCapableImageWriter.getDefaultImageMetadata(imageTypeSpecifier, defaultImageWriteParam);
            String metaFormatName = imageMetaData.getNativeMetadataFormatName();
            Node root = imageMetaData.getAsTree(metaFormatName);
            IIOMetadataNode graphicsControlExtensionNode = (IIOMetadataNode)AnimatedTestResource.getOrCreateChild(root, "GraphicControlExtension");
            graphicsControlExtensionNode.setAttribute("disposalMethod", "none");
            graphicsControlExtensionNode.setAttribute("userInputFlag", "FALSE");
            graphicsControlExtensionNode.setAttribute("transparentColorFlag", "FALSE");
            graphicsControlExtensionNode.setAttribute("delayTime", Integer.toString(50));
            graphicsControlExtensionNode.setAttribute("transparentColorIndex", "0");
            boolean loopContinuously = false;
            Node applicationExtensionsNode = AnimatedTestResource.getOrCreateChild(root, "ApplicationExtensions");
            IIOMetadataNode netscapeExtension = new IIOMetadataNode("ApplicationExtension");
            netscapeExtension.setAttribute("applicationID", "NETSCAPE");
            netscapeExtension.setAttribute("authenticationCode", "2.0");
            byte numLoops = (byte)(!loopContinuously ? 1 : 0);
            netscapeExtension.setUserObject(new byte[]{1, numLoops, 0});
            applicationExtensionsNode.appendChild(netscapeExtension);
            imageMetaData.setFromTree(metaFormatName, root);
            sequenceCapableImageWriter.prepareWriteSequence(null);
            for (int i = 1; i <= 10; ++i) {
                g2d.setPaint(new GradientPaint(0.0f, i * dimension.height / 10, Color.WHITE, 0.0f, dimension.height, this.getColor()));
                g2d.fillRect(0, 0, dimension.width, dimension.height);
                sequenceCapableImageWriter.writeToSequence(new IIOImage(image, null, imageMetaData), defaultImageWriteParam);
            }
            sequenceCapableImageWriter.endWriteSequence();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (imageOutputStream != null) {
                try {
                    imageOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            g2d.dispose();
            sequenceCapableImageWriter.dispose();
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }
}

