/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import java.util.Date;
import java.util.Map;
import javax.faces.FacesWrapper;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import org.richfaces.resource.AbstractCacheableResource;
import org.richfaces.resource.CacheableResource;
import org.richfaces.resource.StateHolderResource;
import org.richfaces.resource.VersionedResource;
import org.richfaces.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseResourceWrapper<T>
extends AbstractCacheableResource
implements VersionedResource,
StateHolder,
FacesWrapper<T> {
    private T resourceObject;

    public BaseResourceWrapper(T resourceObject) {
        this.resourceObject = resourceObject;
    }

    protected abstract Map<String, String> getWrappedResourceResponseHeaders();

    @Override
    public Map<String, String> getResponseHeaders() {
        Map<String, String> headers = super.getResponseHeaders();
        Map<String, String> userHeaders = this.getWrappedResourceResponseHeaders();
        if (userHeaders != null) {
            headers.putAll(userHeaders);
        }
        return headers;
    }

    public String getVersion() {
        if (this.resourceObject instanceof VersionedResource) {
            return ((VersionedResource)this.resourceObject).getVersion();
        }
        return null;
    }

    @Override
    public boolean isCacheable(FacesContext context) {
        if (this.resourceObject instanceof CacheableResource) {
            return ((CacheableResource)this.resourceObject).isCacheable(context);
        }
        return false;
    }

    @Override
    public Date getExpires(FacesContext context) {
        if (this.resourceObject instanceof CacheableResource) {
            return ((CacheableResource)this.resourceObject).getExpires(context);
        }
        return null;
    }

    @Override
    public String getEntityTag(FacesContext context) {
        if (this.resourceObject instanceof CacheableResource) {
            return ((CacheableResource)this.resourceObject).getEntityTag(context);
        }
        return null;
    }

    @Override
    public int getTimeToLive(FacesContext context) {
        if (this.resourceObject instanceof CacheableResource) {
            return ((CacheableResource)this.resourceObject).getTimeToLive(context);
        }
        return 0;
    }

    public boolean isTransient() {
        if (this.resourceObject instanceof StateHolderResource) {
            return ((StateHolderResource)this.resourceObject).isTransient();
        }
        if (this.resourceObject instanceof StateHolder) {
            return ((StateHolder)this.resourceObject).isTransient();
        }
        return true;
    }

    public void setTransient(boolean newTransientValue) {
        if (this.resourceObject instanceof StateHolder) {
            ((StateHolder)this.resourceObject).setTransient(newTransientValue);
        }
    }

    public Object saveState(FacesContext context) {
        return Util.saveResourceState(context, this.resourceObject);
    }

    public void restoreState(FacesContext context, Object state) {
        Util.restoreResourceState(context, this.resourceObject, state);
    }

    public T getWrapped() {
        return this.resourceObject;
    }
}

