/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.application.Resource;
import javax.faces.context.FacesContext;
import org.ajax4jsf.io.ByteBuffer;
import org.ajax4jsf.io.FastBufferInputStream;
import org.ajax4jsf.io.FastBufferOutputStream;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.resource.AbstractCacheableResource;
import org.richfaces.resource.ResourceUtils;
import org.richfaces.util.Util;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CachedResourceImpl
extends AbstractCacheableResource {
    private static final float CACHE_EXPIRATION_COEFFICIENT = 0.9f;
    private static final Logger LOGGER = RichfacesLogger.RESOURCE.getLogger();
    private static final int MAX_AGE_VALUE_GROUP = 2;
    private static final int SMAX_AGE_GROUP = 1;
    private static final Pattern MAX_AGE = Pattern.compile("^(?:(s-maxage)|max-age)=(\\d+)$", 2);
    private ByteBuffer content;
    private String entityTag;
    private Date expired;
    private Map<String, String> headers;
    private Date lastModified;

    CachedResourceImpl() {
    }

    private void initializeFromHeaders() {
        this.entityTag = null;
        this.lastModified = null;
        this.expired = null;
        Date expiredFromHeader = null;
        int maxAge = 0;
        for (Map.Entry<String, String> headerEntry : this.headers.entrySet()) {
            String[] values;
            String headerKey = headerEntry.getKey().toLowerCase(Locale.US);
            if ("etag".equals(headerKey)) {
                this.entityTag = headerEntry.getValue();
            }
            if ("last-modified".equals(headerKey)) {
                this.lastModified = Util.parseHttpDate(headerEntry.getValue());
            }
            if ("expires".equals(headerKey)) {
                expiredFromHeader = Util.parseHttpDate(headerEntry.getValue());
            }
            if (!"cache-control".equals(headerKey)) continue;
            for (String value : values = headerEntry.getValue().split(",")) {
                boolean isSMaxAge;
                Matcher matcher = MAX_AGE.matcher(value.trim());
                if (!matcher.find()) continue;
                boolean bl = isSMaxAge = matcher.group(1) != null;
                if (maxAge > 0 && !isSMaxAge) continue;
                try {
                    maxAge = (int)ResourceUtils.secondToMillis(Integer.parseInt(matcher.group(2)));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        }
        long currentTime = this.getCurrentTime();
        if (maxAge > 0) {
            this.expired = new Date((long)((float)currentTime + 0.9f * (float)maxAge));
        } else if (expiredFromHeader != null) {
            this.expired = new Date((long)(0.9f * (float)expiredFromHeader.getTime() + 0.100000024f * (float)currentTime));
        }
    }

    @Override
    long getCurrentTime() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer readContent(InputStream is) throws IOException {
        if (is == null) {
            throw new NullPointerException("Resource input stream is null");
        }
        FastBufferOutputStream os = new FastBufferOutputStream();
        try {
            Util.copyStreamContent(is, os);
        }
        finally {
            block14: {
                block13: {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        if (!LOGGER.isDebugEnabled()) break block13;
                        LOGGER.debug(e.getMessage(), (Throwable)e);
                    }
                }
                try {
                    os.close();
                }
                catch (IOException e) {
                    if (!LOGGER.isDebugEnabled()) break block14;
                    LOGGER.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
        ByteBuffer buffer = os.getFirstBuffer();
        buffer.compact();
        return buffer;
    }

    public void initialize(Resource resource) throws IOException {
        this.setResourceName(resource.getResourceName());
        this.setContentType(resource.getContentType());
        this.headers = resource.getResponseHeaders();
        this.initializeFromHeaders();
        this.content = CachedResourceImpl.readContent(resource.getInputStream());
    }

    public InputStream getInputStream() throws IOException {
        return new FastBufferInputStream(this.content);
    }

    @Override
    public String getRequestPath() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, String> getResponseHeaders() {
        return new HashMap<String, String>(this.headers);
    }

    @Override
    public URL getURL() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCacheable(FacesContext context) {
        return true;
    }

    @Override
    public String getEntityTag(FacesContext context) {
        return this.entityTag;
    }

    @Override
    protected Date getLastModified(FacesContext context) {
        return this.lastModified;
    }

    public Date getExpired(FacesContext context) {
        return this.expired;
    }

    public String toString() {
        return MessageFormat.format("Cached resource: {0}", this.getResourceName());
    }
}

