/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.imageio.ImageIO;
import org.ajax4jsf.util.HtmlColor;
import org.ajax4jsf.util.HtmlDimensions;
import org.richfaces.resource.BaseResourceWrapper;
import org.richfaces.resource.ImageType;
import org.richfaces.resource.Java2DUserResource;
import org.richfaces.resource.Java2DUserResourceWrapper;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Java2DUserResourceWrapperImpl
extends BaseResourceWrapper<Java2DUserResource>
implements Java2DUserResourceWrapper {
    public Java2DUserResourceWrapperImpl(Java2DUserResource resourceObject) {
        super(resourceObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws IOException {
        Java2DUserResource j2DUserResource = (Java2DUserResource)this.getWrapped();
        Dimension dimension = j2DUserResource.getDimension();
        int width = dimension.width;
        int height = dimension.height;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageType imageType = j2DUserResource.getImageType();
        if (width > 0 && height > 0) {
            BufferedImage image = imageType.createImage(width, height);
            Graphics2D g2d = image.createGraphics();
            try {
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
                g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                j2DUserResource.paint(g2d, dimension);
            }
            finally {
                g2d.dispose();
            }
            try {
                ImageIO.write((RenderedImage)image, imageType.getFormatName(), baos);
            }
            finally {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public String getContentType() {
        return ((Java2DUserResource)this.getWrapped()).getImageType().getMimeType();
    }

    protected String getValueParameter(FacesContext context, String name) {
        SkinFactory skinFactory = SkinFactory.getInstance();
        Skin skin = skinFactory.getSkin(context);
        String value = (String)skin.getParameter(context, name);
        if (value == null || value.length() == 0) {
            skin = skinFactory.getDefaultSkin(context);
            value = (String)skin.getParameter(context, name);
        }
        return value;
    }

    protected Integer getColorValueParameter(FacesContext context, String name, boolean useDefault) {
        Skin skin = useDefault ? SkinFactory.getInstance().getDefaultSkin(context) : SkinFactory.getInstance().getSkin(context);
        return this.decodeColor((String)skin.getParameter(context, name));
    }

    protected Integer getHeight(FacesContext context, String heightParamName) {
        SkinFactory skinFactory = SkinFactory.getInstance();
        Skin skin = skinFactory.getSkin(context);
        String height = (String)skin.getParameter(context, heightParamName);
        if (height == null || height.length() == 0) {
            skin = skinFactory.getDefaultSkin(context);
            height = (String)skin.getParameter(context, heightParamName);
        }
        if (height != null && height.length() != 0) {
            return HtmlDimensions.decode(height).intValue();
        }
        return 16;
    }

    protected Integer decodeColor(String value) {
        if (value != null && value.length() != 0) {
            return HtmlColor.decode(value).getRGB();
        }
        return null;
    }

    @Override
    protected Map<String, String> getWrappedResourceResponseHeaders() {
        return ((Java2DUserResource)this.getWrapped()).getResponseHeaders();
    }

    @Override
    protected Date getLastModified(FacesContext context) {
        return ((Java2DUserResource)this.getWrapped()).getLastModified();
    }
}

