/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ResourceHandlerWrapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import org.ajax4jsf.cache.Cache;
import org.richfaces.application.DependencyInjector;
import org.richfaces.application.ServiceTracker;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.resource.AbstractCacheableResource;
import org.richfaces.resource.BaseResourceWrapper;
import org.richfaces.resource.CachedResourceImpl;
import org.richfaces.resource.CompiledCSSResource;
import org.richfaces.resource.DynamicResource;
import org.richfaces.resource.Java2DUserResource;
import org.richfaces.resource.Java2DUserResourceWrapperImpl;
import org.richfaces.resource.ResourceCodec;
import org.richfaces.resource.UserResource;
import org.richfaces.resource.UserResourceWrapperImpl;
import org.richfaces.resource.VersionedResource;
import org.richfaces.util.RequestStateManager;
import org.richfaces.util.Util;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceHandlerImpl
extends ResourceHandlerWrapper {
    public static final String RICHFACES_RESOURCE_IDENTIFIER = "/rfRes/";
    public static final String RESOURCE_CACHE_NAME = "org.richfaces.ResourcesCache";
    public static final String HANDLER_START_TIME_ATTRIBUTE = ResourceHandlerImpl.class.getName() + ":StartTime";
    private static final Logger LOGGER = RichfacesLogger.RESOURCE.getLogger();
    private ResourceHandler defaultHandler;

    public ResourceHandlerImpl(ResourceHandler defaultHandler) {
        this.defaultHandler = defaultHandler;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(MessageFormat.format("Instance of {0} resource handler created", ((Object)((Object)this)).getClass().getName()));
        }
    }

    protected static String getResourcePathFromRequest(FacesContext context) {
        String resourceName = Util.decodeResourceURL(context);
        if (resourceName != null) {
            if (resourceName.startsWith(RICHFACES_RESOURCE_IDENTIFIER)) {
                return resourceName.substring(RICHFACES_RESOURCE_IDENTIFIER.length());
            }
            return null;
        }
        LOGGER.warn("Resource key not found" + resourceName);
        return null;
    }

    protected boolean isThisHandlerResourceRequest(FacesContext context) {
        Boolean resourceRequest = RequestStateManager.BooleanRequestStateVariable.ResourceRequest.get(context);
        if (resourceRequest == null) {
            String resourcePath = ResourceHandlerImpl.getResourcePathFromRequest(context);
            resourceRequest = resourcePath != null && resourcePath.length() > 0;
            RequestStateManager.BooleanRequestStateVariable.ResourceRequest.set(context, resourceRequest);
            if (LOGGER.isDebugEnabled() && resourceRequest.booleanValue()) {
                LOGGER.debug(MessageFormat.format("Resource request detected: {0}", resourcePath));
            }
        }
        return resourceRequest;
    }

    public boolean isResourceRequest(FacesContext context) {
        return this.isThisHandlerResourceRequest(context) || this.defaultHandler.isResourceRequest(context);
    }

    private Resource lookupInCache(Cache cache, String resourceKey) {
        Resource resource = (Resource)cache.get((Object)resourceKey);
        if (LOGGER.isDebugEnabled()) {
            if (resource == null) {
                LOGGER.debug("Resource was not located in cache");
            } else {
                LOGGER.debug("Resource was located in cache");
            }
        }
        return resource;
    }

    private static void sendNotModified(FacesContext context) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("User agent has actual resource copy - sending 304 status code");
        }
        context.getExternalContext().setResponseStatus(304);
    }

    private void logResourceProblem(FacesContext context, Throwable throwable, String messagePattern, Object ... arguments) {
        boolean isProductionStage = context.isProjectStage(ProjectStage.Production);
        if (LOGGER.isWarnEnabled() || !isProductionStage && LOGGER.isInfoEnabled()) {
            String formattedMessage = MessageFormat.format(messagePattern, arguments);
            if (throwable != null) {
                LOGGER.warn(formattedMessage, throwable);
            } else if (isProductionStage) {
                LOGGER.info(formattedMessage);
            } else {
                LOGGER.warn(formattedMessage);
            }
        }
    }

    private void logMissingResource(FacesContext context, String resourceData) {
        this.logResourceProblem(context, null, "Resource {0} was not found", resourceData);
    }

    private static void sendResourceNotFound(FacesContext context) {
        context.getExternalContext().setResponseStatus(404);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleResourceRequest(FacesContext context) throws IOException {
        if (this.isThisHandlerResourceRequest(context)) {
            ResourceCodec resourceCodec = (ResourceCodec)ServiceTracker.getService((FacesContext)context, ResourceCodec.class);
            String resourcePath = ResourceHandlerImpl.getResourcePathFromRequest(context);
            assert (resourcePath != null && resourcePath.length() != 0);
            String resourceKey = resourceCodec.getResourceKey(context, resourcePath);
            assert (resourceKey != null && resourceKey.length() != 0);
            Cache cache = (Cache)ServiceTracker.getService((FacesContext)context, Cache.class);
            Resource resource = this.lookupInCache(cache, resourceKey);
            if (resource == null) {
                AbstractCacheableResource cacheableResource;
                String resourceName = resourceCodec.decodeResourceName(context, resourcePath);
                if (resourceName == null || resourceName.length() == 0) {
                    this.logMissingResource(context, resourceKey);
                    ResourceHandlerImpl.sendResourceNotFound(context);
                    return;
                }
                if (resourceName.lastIndexOf(".ecss") != -1) {
                    String libraryName = resourceCodec.decodeLibraryName(context, resourcePath);
                    resource = new CompiledCSSResource(resourceName, libraryName, this.defaultHandler);
                }
                if (resource == null) {
                    resource = this.createHandlerDependentResource(resourceName, null);
                }
                if (resource == null) {
                    this.logMissingResource(context, resourceName);
                    ResourceHandlerImpl.sendResourceNotFound(context);
                    return;
                }
                if (resource instanceof VersionedResource) {
                    VersionedResource versionedResource = (VersionedResource)resource;
                    String existingVersion = versionedResource.getVersion();
                    String requestedVersion = resourceCodec.decodeResourceVersion(context, resourcePath);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(MessageFormat.format("Client requested {0} version of resource, server has {1} version", String.valueOf(requestedVersion), String.valueOf(existingVersion)));
                    }
                    if (existingVersion != null && requestedVersion != null && !existingVersion.equals(requestedVersion)) {
                        this.logResourceProblem(context, null, "Resource {0} of version {1} was not found", resourceName, requestedVersion);
                        ResourceHandlerImpl.sendResourceNotFound(context);
                        return;
                    }
                }
                Object decodedData = resourceCodec.decodeResourceData(context, resourcePath);
                if (LOGGER.isDebugEnabled()) {
                    if (decodedData != null) {
                        LOGGER.debug("Resource state data succesfully decoded");
                    } else {
                        LOGGER.debug("Resource state data decoded as null");
                    }
                }
                Util.restoreResourceState(context, resource, decodedData);
                if (resource instanceof AbstractCacheableResource && (cacheableResource = (AbstractCacheableResource)resource).isCacheable(context)) {
                    CachedResourceImpl cachedResource = new CachedResourceImpl();
                    cachedResource.initialize(resource);
                    resource = this.lookupInCache(cache, resourceKey);
                    if (resource == null) {
                        Date cacheExpirationDate = cachedResource.getExpired(context);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(new MessageFormat("Storing {0} resource in cache until {1,date,dd MMM yyyy HH:mm:ss zzz}", Locale.US).format(new Object[]{resourceKey, cacheExpirationDate}));
                        }
                        cache.put((Object)resourceKey, (Object)cachedResource, cacheExpirationDate);
                        resource = cachedResource;
                    }
                }
            }
            if (resource.userAgentNeedsUpdate(context)) {
                HttpServletRequest httpServletRequest;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("User agent needs resource update, encoding resource");
                }
                ExternalContext externalContext = context.getExternalContext();
                Map headers = resource.getResponseHeaders();
                for (Map.Entry headerEntry : headers.entrySet()) {
                    String headerName = (String)headerEntry.getKey();
                    String headerValue = (String)headerEntry.getValue();
                    if ("content-length".equals(headerName.toLowerCase(Locale.US))) {
                        try {
                            externalContext.setResponseContentLength(Integer.parseInt(headerValue));
                        }
                        catch (NumberFormatException e) {}
                        continue;
                    }
                    externalContext.setResponseHeader(headerName, headerValue);
                }
                String contentType = resource.getContentType();
                if (contentType != null) {
                    externalContext.setResponseContentType(contentType);
                }
                if (!"HEAD".equals((httpServletRequest = (HttpServletRequest)externalContext.getRequest()).getMethod())) {
                    InputStream is = resource.getInputStream();
                    OutputStream os = externalContext.getResponseOutputStream();
                    try {
                        Util.copyStreamContent(is, os);
                    }
                    finally {
                        block38: {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException e) {
                                    if (!LOGGER.isDebugEnabled()) break block38;
                                    LOGGER.debug(e.getMessage(), (Throwable)e);
                                }
                            }
                        }
                    }
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Resource succesfully encoded");
                }
            } else {
                ResourceHandlerImpl.sendNotModified(context);
            }
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Passing request to the next resource handler in chain");
            }
            this.defaultHandler.handleResourceRequest(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void injectProperties(Object resource, Map<String, String> parameters) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map attributes = facesContext.getAttributes();
        try {
            attributes.put("rfResourceParam", parameters);
            ((DependencyInjector)ServiceTracker.getService(DependencyInjector.class)).inject(facesContext, resource);
        }
        finally {
            attributes.remove("rfResourceParam");
        }
    }

    protected Resource createHandlerDependentResource(String resourceName, Map<String, String> parameters) {
        BaseResourceWrapper resource = null;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            try {
                Class<?> loadedClass = Class.forName(resourceName, false, contextClassLoader);
                boolean legitimateResource = false;
                DynamicResource annotation = loadedClass.getAnnotation(DynamicResource.class);
                boolean bl = legitimateResource = annotation != null;
                if (legitimateResource) {
                    LOGGER.debug(MessageFormat.format("Dynamic resource annotation is present on resource class {0}", resourceName));
                } else {
                    LOGGER.debug(MessageFormat.format("Dynamic resource annotation is not present on resource class {0}", resourceName));
                }
                if (!legitimateResource) {
                    URL resourceMarkerUrl = contextClassLoader.getResource("META-INF/" + resourceName + ".resource.properties");
                    boolean bl2 = legitimateResource = resourceMarkerUrl != null;
                    if (LOGGER.isDebugEnabled()) {
                        if (legitimateResource) {
                            LOGGER.debug(MessageFormat.format("Marker file for {0} resource found in classpath", resourceName));
                        } else {
                            LOGGER.debug(MessageFormat.format("Marker file for {0} resource does not exist", resourceName));
                        }
                    }
                }
                if (legitimateResource) {
                    Object wrappedResource;
                    if (Java2DUserResource.class.isAssignableFrom(loadedClass)) {
                        Java2DUserResource java2DUserResource;
                        wrappedResource = java2DUserResource = (Java2DUserResource)loadedClass.newInstance();
                        resource = new Java2DUserResourceWrapperImpl(java2DUserResource);
                    } else if (UserResource.class.isAssignableFrom(loadedClass)) {
                        UserResource userResource = (UserResource)loadedClass.newInstance();
                        wrappedResource = userResource;
                        resource = new UserResourceWrapperImpl(userResource);
                    } else {
                        Class<Resource> resourceClass = loadedClass.asSubclass(Resource.class);
                        resource = resourceClass.newInstance();
                        wrappedResource = resource;
                    }
                    if (parameters != null) {
                        this.injectProperties(wrappedResource, parameters);
                    }
                    resource.setResourceName(resourceName);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(MessageFormat.format("Successfully created instance of {0} resource", resourceName));
                    }
                }
            }
            catch (ClassNotFoundException e) {
            }
            catch (Exception e) {
                this.logResourceProblem(FacesContext.getCurrentInstance(), e, "Error creating resource {0}", resourceName);
            }
            catch (LinkageError e) {
                this.logResourceProblem(FacesContext.getCurrentInstance(), e, "Error creating resource {0}", resourceName);
            }
        }
        return resource;
    }

    public Resource createResource(String resourceName, String libraryName, String contentType) {
        CompiledCSSResource result = null;
        Map<String, String> params = Util.parseResourceParameters(resourceName);
        if ((resourceName = this.extractParametersFromResourceName(resourceName)).lastIndexOf(".ecss") != -1) {
            result = new CompiledCSSResource(resourceName, libraryName, this.defaultHandler);
        } else if (resourceName != null && (libraryName == null || libraryName.length() == 0)) {
            result = this.createHandlerDependentResource(resourceName, params);
        }
        if (result == null) {
            result = this.defaultHandler.createResource(resourceName, libraryName, contentType);
        }
        return result;
    }

    private String extractParametersFromResourceName(String resourceName) {
        if (resourceName.lastIndexOf("?") == -1) {
            return resourceName;
        }
        return resourceName.substring(0, resourceName.lastIndexOf("?"));
    }

    public Resource createResource(String resourceName, String libraryName) {
        return this.createResource(resourceName, libraryName, null);
    }

    public Resource createResource(String resourceName) {
        return this.createResource(resourceName, null, null);
    }

    public String getRendererTypeForResourceName(String resourceName) {
        if (resourceName.endsWith(".ecss")) {
            return "javax.faces.resource.Stylesheet";
        }
        return this.defaultHandler.getRendererTypeForResourceName(resourceName);
    }

    public boolean libraryExists(String libraryName) {
        return this.defaultHandler.libraryExists(libraryName);
    }

    public ResourceHandler getWrapped() {
        return this.defaultHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Thread thread = Thread.currentThread();
        ClassLoader initialTCCL = thread.getContextClassLoader();
        try {
            ClassLoader systemCL = ClassLoader.getSystemClassLoader();
            thread.setContextClassLoader(systemCL);
            ImageIO.setUseCache(false);
        }
        finally {
            thread.setContextClassLoader(initialTCCL);
        }
    }
}

