/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.faces.context.FacesContext;
import org.ajax4jsf.resource.Java2Dresource;
import org.ajax4jsf.util.HtmlColor;
import org.richfaces.VersionBean;
import org.richfaces.resource.DynamicResource;
import org.richfaces.resource.ImageType;
import org.richfaces.resource.ResourceUtils;
import org.richfaces.resource.VersionedResource;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;

@DynamicResource
public class TestResource2
extends Java2Dresource
implements VersionedResource {
    private static final int MASK_FOR_COLOR_WITHOUT_ALPHA_CHANNEL = 0xFFFFFF;
    private Color color;
    private Dimension dimension = new Dimension(20, 150);

    public TestResource2() {
        super(ImageType.PNG);
        FacesContext context = FacesContext.getCurrentInstance();
        Skin skin = SkinFactory.getInstance().getSkin(context);
        Object parameter = skin.getParameter(context, "headerGradientColor");
        this.color = HtmlColor.decode(parameter.toString());
    }

    protected void paint(Graphics2D graphics2d, Dimension dim) {
        super.paint(graphics2d, dim);
        graphics2d.setPaint(new GradientPaint(0.0f, 0.0f, Color.WHITE, dim.width, dim.height, this.color));
        graphics2d.fillRect(0, 0, dim.width, dim.height);
    }

    public void readState(FacesContext context, DataInput stream) throws IOException {
        super.readState(context, stream);
        this.color = new Color(stream.readInt());
    }

    public void writeState(FacesContext context, DataOutput stream) throws IOException {
        super.writeState(context, stream);
        stream.writeInt(this.color.getRGB());
    }

    public String getEntityTag(FacesContext context) {
        return ResourceUtils.formatWeakTag(this.getColorWitoutAlphaChanel());
    }

    private String getColorWitoutAlphaChanel() {
        return Integer.toHexString(this.color.getRGB() & 0xFFFFFF);
    }

    public String getVersion() {
        return VersionBean.VERSION.getResourceVersion();
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }
}

