/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.renderkit.AjaxEventOptions;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.ajax4jsf.renderkit.HandlersChain;
import org.ajax4jsf.renderkit.RendererBase;
import org.richfaces.component.AbstractPoll;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(name="jquery.js"), @ResourceDependency(name="richfaces.js")})
public class AjaxPollRenderer
extends RendererBase {
    public static final String COMPONENT_FAMILY = "org.richfaces.Poll";
    public static final String RENDERER_TYPE = "org.richfaces.PollRenderer";
    private static final String AJAX_POLL_FUNCTION = "RichFaces.startPoll";

    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        AbstractPoll poll = (AbstractPoll)component;
        writer.startElement("span", component);
        writer.writeAttribute("style", (Object)"display:none;", null);
        this.getUtils().encodeId(context, component);
        this.getUtils().encodeBeginFormIfNessesary(context, component);
        writer.startElement("script", component);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        StringBuffer script = new StringBuffer("\n");
        if (poll.isEnabled()) {
            String handler;
            JSFunction function = new JSFunction(AJAX_POLL_FUNCTION, new Object[0]);
            HashMap<String, Object> options = new HashMap<String, Object>();
            Integer interval = new Integer(poll.getInterval());
            options.put("pollinterval", interval);
            options.put("pollId", component.getClientId(context));
            HandlersChain handlersChain = new HandlersChain((UIComponent)poll);
            handlersChain.addInlineHandlerFromAttribute(context, "ontimer");
            handlersChain.addBehaviors(context, "timer");
            if (!handlersChain.hasSubmittingBehavior()) {
                JSFunction ajaxFunction = AjaxRendererUtils.buildAjaxFunction((FacesContext)context, (UIComponent)poll, (String)"RichFaces.ajax");
                AjaxEventOptions eventOptions = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)poll);
                if (!eventOptions.isEmpty()) {
                    ajaxFunction.addParameter((Object)eventOptions);
                }
                handlersChain.addInlineHandlerAsValue(context, ajaxFunction.toScript());
            }
            if ((handler = handlersChain.toScript()) != null) {
                JSFunctionDefinition timerHandler = new JSFunctionDefinition(new Object[]{JSReference.EVENT});
                timerHandler.addToBody((Object)handler);
                options.put("ontimer", timerHandler);
            }
            function.addParameter(options);
            function.appendScript(script);
        } else {
            script.append("RichFaces.stopPoll('").append(component.getClientId(context)).append("')");
        }
        script.append(";\n");
        writer.writeText((Object)script.toString(), null);
        writer.endElement("script");
        this.getUtils().encodeEndFormIfNessesary(context, component);
        writer.endElement("span");
    }

    protected Class<? extends UIComponent> getComponentClass() {
        return AbstractPoll.class;
    }

    protected void doDecode(FacesContext context, UIComponent component) {
        Map requestParameterMap;
        super.doDecode(context, component);
        AbstractPoll poll = (AbstractPoll)component;
        if (poll.isEnabled() && (requestParameterMap = context.getExternalContext().getRequestParameterMap()).get(poll.getClientId(context)) != null) {
            new ActionEvent((UIComponent)poll).queue();
        }
    }
}

