/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.javascript.JSObject;
import org.ajax4jsf.renderkit.AjaxEventOptions;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.richfaces.component.AbstractTogglePanel;
import org.richfaces.component.AbstractTogglePanelItem;
import org.richfaces.renderkit.html.DivPanelRenderer;
import org.richfaces.renderkit.html.TogglePanelItemRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(name="jquery.js"), @ResourceDependency(name="richfaces.js"), @ResourceDependency(name="richfaces-event.js"), @ResourceDependency(name="richfaces-base-component.js"), @ResourceDependency(name="script/TogglePanel.js")})
public class TogglePanelRenderer
extends DivPanelRenderer {
    private static final String VALUE_POSTFIX = "-value";

    protected void doDecode(FacesContext context, UIComponent component) {
        AbstractTogglePanel panel;
        AbstractTogglePanelItem panelItem;
        String compClientId;
        String clientId;
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String newValue = (String)requestMap.get(TogglePanelRenderer.getSelectedItemRequestParamName(context, component));
        if (newValue != null) {
            this.setSubmittedValue(component, newValue);
        }
        if ((clientId = (String)requestMap.get(compClientId = component.getClientId(context))) != null && clientId.equals(compClientId) && (panelItem = (panel = (AbstractTogglePanel)component).getItem(newValue)) != null) {
            context.getPartialViewContext().getRenderIds().add(panelItem.getClientId(context));
            this.addOnCompleteParam(newValue, panel);
        }
    }

    private void addOnCompleteParam(String newValue, AbstractTogglePanel panel) {
        StringBuilder onComplete = new StringBuilder();
        onComplete.append("RichFaces.$('").append(panel.getClientId()).append("').onCompleteHandler('").append(panel.getSelectedItem()).append("','").append(newValue).append("');");
        AjaxContext.getCurrentInstance().appendOncomplete((Object)onComplete.toString());
    }

    private static String getSelectedItemRequestParamName(FacesContext context, UIComponent component) {
        return component.getClientId(context) + VALUE_POSTFIX;
    }

    public void setSubmittedValue(UIComponent component, Object value) {
        if (component instanceof AbstractTogglePanel) {
            ((AbstractTogglePanel)component).setSubmittedSelectedItem((String)value);
        }
    }

    @Override
    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent comp) throws IOException {
        super.doEncodeBegin(writer, context, comp);
        AbstractTogglePanel panel = (AbstractTogglePanel)comp;
        writer.startElement("input", comp);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("value", (Object)panel.getSelectedItem(), "selectedItem");
        writer.writeAttribute("id", (Object)TogglePanelRenderer.getSelectedItemRequestParamName(context, comp), null);
        writer.writeAttribute("name", (Object)TogglePanelRenderer.getSelectedItemRequestParamName(context, comp), null);
        writer.endElement("input");
    }

    protected void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        if (component.getChildCount() <= 0) {
            return;
        }
        for (UIComponent child : component.getChildren()) {
            if (!(child instanceof AbstractTogglePanelItem)) {
                throw new IllegalStateException("Child of TogglePanel can be only TogglePanelItem");
            }
            this.doEncodeChild(context, (AbstractTogglePanel)component, (AbstractTogglePanelItem)child);
        }
    }

    private void doEncodeChild(FacesContext facesContext, AbstractTogglePanel panel, AbstractTogglePanelItem item) throws IOException {
        boolean isSelected = panel.getSelectedItem().equals(item.getName());
        if (isSelected) {
            item.encodeAll(facesContext);
        } else {
            switch (item.getSwitchType()) {
                case client: {
                    TogglePanelRenderer.hidePanelItem((UIComponent)item);
                    item.encodeAll(facesContext);
                    break;
                }
                case ajax: {
                    if (!item.isRendered()) break;
                    TogglePanelRenderer.hidePanelItem((UIComponent)item);
                    item.encodeBegin(facesContext);
                    item.encodeEnd(facesContext);
                    break;
                }
                case server: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown switch type : " + (Object)((Object)item.getSwitchType()));
                }
            }
        }
    }

    private static void hidePanelItem(UIComponent item) {
        item.getAttributes().put("style", "display:none");
    }

    protected JSObject getScriptObject(FacesContext context, UIComponent component) {
        return new JSObject("RichFaces.ui.TogglePanel", new Object[]{component.getClientId(), this.getScriptObjectOptions(context, component)});
    }

    @Override
    protected Map<String, Object> getScriptObjectOptions(FacesContext context, UIComponent component) {
        AbstractTogglePanel panel = (AbstractTogglePanel)component;
        HashMap<String, Object> options = new HashMap<String, Object>(3);
        options.put("selectedItem", panel.getValue());
        options.put("switchMode", (Object)panel.getSwitchType());
        options.put("items", this.getChildrenScriptObjects(context, (UIComponent)panel));
        options.put("ajax", TogglePanelRenderer.getAjaxOptions(context, (UIComponent)panel));
        return options;
    }

    private static AjaxEventOptions getAjaxOptions(FacesContext context, UIComponent panel) {
        return AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)panel);
    }

    private List<JSObject> getChildrenScriptObjects(FacesContext context, UIComponent component) {
        ArrayList<JSObject> res = new ArrayList<JSObject>(component.getChildCount());
        for (UIComponent child : component.getChildren()) {
            res.add(this.getChildScriptObject(context, (AbstractTogglePanelItem)child));
        }
        return res;
    }

    private JSObject getChildScriptObject(FacesContext context, AbstractTogglePanelItem child) {
        return ((TogglePanelItemRenderer)child.getRenderer(context)).getScriptObject(context, (UIComponent)child);
    }

    @Override
    protected Class<? extends UIComponent> getComponentClass() {
        return AbstractTogglePanel.class;
    }
}

