/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.application;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Locale;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.ajax4jsf.Messages;
import org.richfaces.log.RichfacesLogger;
import org.slf4j.Logger;

public class ViewHandlerWrapper
extends ViewHandler {
    private static final String HANDLERS = "org.ajax4jsf.VIEW_HANDLERS";
    private static final Logger LOG = RichfacesLogger.APPLICATION.getLogger();
    protected ViewHandler handler;

    public ViewHandlerWrapper(ViewHandler handler) {
        this.handler = handler;
    }

    public Locale calculateLocale(FacesContext context) {
        return this.handler.calculateLocale(context);
    }

    public String calculateRenderKitId(FacesContext context) {
        return this.handler.calculateRenderKitId(context);
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        return this.handler.createView(context, viewId);
    }

    public String getActionURL(FacesContext context, String url) {
        return this.handler.getActionURL(context, url);
    }

    public String getResourceURL(FacesContext context, String url) {
        return this.handler.getResourceURL(context, url);
    }

    public void renderView(FacesContext context, UIViewRoot root) throws IOException, FacesException {
        this.handler.renderView(context, root);
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        return this.handler.restoreView(context, viewId);
    }

    public void writeState(FacesContext context) throws IOException {
        this.handler.writeState(context);
    }

    protected ViewHandler getHandler() {
        return this.handler;
    }

    public void initView(FacesContext context) throws FacesException {
        this.handler.initView(context);
    }

    public String calculateCharacterEncoding(FacesContext context) {
        return this.handler.calculateCharacterEncoding(context);
    }

    public void fillChain(FacesContext context) {
        String handlers = context.getExternalContext().getInitParameter(HANDLERS);
        if (null != handlers) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            String[] classes = handlers.split(",");
            for (int i = 0; i < classes.length; ++i) {
                String handlerClass = classes[i];
                if (LOG.isDebugEnabled()) {
                    LOG.debug(Messages.getMessage("CREATE_ALTERNATE_HANDLER", handlerClass));
                }
                try {
                    Class<?> clazz = classLoader.loadClass(handlerClass);
                    try {
                        Constructor<?> constructor = clazz.getConstructor(ViewHandler.class);
                        this.handler = (ViewHandler)constructor.newInstance(this.handler);
                    }
                    catch (NoSuchMethodException e) {
                        if (LOG.isWarnEnabled()) {
                            LOG.warn(Messages.getMessage("ALTERNATE_HANDLER_CONSTRUCTOR_WARNING"));
                        }
                        this.handler = (ViewHandler)clazz.newInstance();
                    }
                    continue;
                }
                catch (Exception e) {
                    LOG.error(Messages.getMessage("VIEW_HANDLER_INSTANTIATION_ERROR"), (Throwable)e);
                }
            }
        }
    }
}

