/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.javascript;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.MissingResourceException;
import javax.faces.FacesException;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.Messages;
import org.ajax4jsf.javascript.JSEncoder;
import org.ajax4jsf.javascript.PropertyUtils;
import org.ajax4jsf.javascript.ResponseWriterWrapper;
import org.ajax4jsf.javascript.ScriptString;
import org.ajax4jsf.javascript.StringBuilderWriter;
import org.richfaces.log.RichfacesLogger;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScriptUtils {
    private static final Logger LOG = RichfacesLogger.UTIL.getLogger();
    private static final char[] CSS_SELECTOR_CHARS_TO_ESCAPE = ScriptUtils.createSortedCharArray("#;&,.+*~':\"!^$[]()=>|/");

    private ScriptUtils() {
    }

    private static char[] createSortedCharArray(String s) {
        char[] cs = s.toCharArray();
        Arrays.sort(cs);
        return cs;
    }

    private static void writeScriptToStream(Writer writer, Object obj, Map<Object, Boolean> cycleBusterMap) throws IOException {
        Boolean cycleBusterValue = cycleBusterMap.put(obj, Boolean.TRUE);
        if (cycleBusterValue != null) {
            if (LOG.isDebugEnabled()) {
                String formattedMessage;
                try {
                    formattedMessage = Messages.getMessage("JAVASCRIPT_CIRCULAR_REFERENCE", obj);
                }
                catch (MissingResourceException e) {
                    formattedMessage = MessageFormat.format("Circular reference serializing object to JS: {0}", obj);
                }
                LOG.debug(formattedMessage);
            }
            writer.write("null");
        } else if (null == obj) {
            writer.write("null");
        } else if (obj instanceof ScriptString) {
            writer.write(((ScriptString)obj).toScript());
        } else if (obj.getClass().isArray()) {
            writer.write("[");
            boolean first = true;
            for (int i = 0; i < Array.getLength(obj); ++i) {
                Object element = Array.get(obj, i);
                if (!first) {
                    writer.write(44);
                }
                ScriptUtils.writeScriptToStream(writer, element, cycleBusterMap);
                first = false;
            }
            writer.write("] ");
        } else if (obj instanceof Collection) {
            Collection collection = (Collection)obj;
            writer.write("[");
            boolean first = true;
            for (Object element : collection) {
                if (!first) {
                    writer.write(44);
                }
                ScriptUtils.writeScriptToStream(writer, element, cycleBusterMap);
                first = false;
            }
            writer.write("] ");
        } else if (obj instanceof Map) {
            Map map = (Map)obj;
            writer.write("{");
            boolean first = true;
            for (Map.Entry entry : map.entrySet()) {
                if (!first) {
                    writer.write(44);
                }
                ScriptUtils.writeEncodedString(writer, entry.getKey());
                writer.write(":");
                ScriptUtils.writeScriptToStream(writer, entry.getValue(), cycleBusterMap);
                first = false;
            }
            writer.write("} ");
        } else if (obj instanceof Number || obj instanceof Boolean) {
            writer.write(obj.toString());
        } else if (obj instanceof String) {
            ScriptUtils.writeEncodedString(writer, obj);
        } else if (obj instanceof Enum) {
            ScriptUtils.writeEncodedString(writer, obj);
        } else {
            PropertyDescriptor[] propertyDescriptors;
            writer.write("{");
            try {
                propertyDescriptors = PropertyUtils.getPropertyDescriptors(obj);
            }
            catch (Exception e) {
                throw new FacesException("Error in conversion Java Object to JavaScript", (Throwable)e);
            }
            boolean ignorePropertyReadException = obj.getClass().getName().startsWith("java.sql.");
            boolean first = true;
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                Object propertyValue;
                String key = propertyDescriptor.getName();
                if ("class".equals(key)) continue;
                try {
                    propertyValue = PropertyUtils.readPropertyValue(obj, propertyDescriptor);
                }
                catch (Exception e) {
                    if (ignorePropertyReadException) continue;
                    throw new FacesException("Error in conversion Java Object to JavaScript", (Throwable)e);
                }
                if (!first) {
                    writer.write(44);
                }
                ScriptUtils.writeEncodedString(writer, key);
                writer.write(":");
                ScriptUtils.writeScriptToStream(writer, propertyValue, cycleBusterMap);
                first = false;
            }
            writer.write("} ");
        }
        if (cycleBusterValue == null) {
            cycleBusterMap.remove(obj);
        }
    }

    public static void writeToStream(ResponseWriter responseWriter, Object obj) throws IOException {
        ScriptUtils.writeScriptToStream(new ResponseWriterWrapper(responseWriter), obj, new IdentityHashMap<Object, Boolean>());
    }

    public static String toScript(Object obj) {
        StringBuilder sb = new StringBuilder();
        try {
            ScriptUtils.writeScriptToStream(new StringBuilderWriter(sb), obj, new IdentityHashMap<Object, Boolean>());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public static void writeEncodedString(Writer w, Object obj) throws IOException {
        w.write("'");
        ScriptUtils.writeEncoded(w, obj);
        w.write("'");
    }

    public static void addEncodedString(StringBuilder buff, Object obj) {
        try {
            ScriptUtils.writeEncodedString(new StringBuilderWriter(buff), obj);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void writeEncoded(Writer w, Object obj) throws IOException {
        JSEncoder encoder = new JSEncoder();
        char[] chars = obj.toString().toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (!encoder.compile(c)) {
                w.write(encoder.encode(c));
                continue;
            }
            w.write(c);
        }
    }

    public static void addEncoded(StringBuilder buff, Object obj) {
        try {
            ScriptUtils.writeEncoded(new StringBuilderWriter(buff), obj);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String getValidJavascriptName(String s) {
        StringBuffer buf = null;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            byte[] bytes;
            char c = s.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_') {
                if (buf == null) continue;
                buf.append(c);
                continue;
            }
            if (buf == null) {
                buf = new StringBuffer(s.length() + 10);
                buf.append(s.substring(0, i));
            }
            buf.append('_');
            if (c < '\u0010') {
                buf.append('0');
            }
            if (c < '\u0080') {
                buf.append(Integer.toHexString(c).toUpperCase());
                continue;
            }
            try {
                bytes = Character.toString(c).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            for (int j = 0; j < bytes.length; ++j) {
                int intVal = bytes[j];
                if (intVal < 0) {
                    intVal = 256 + intVal;
                } else if (intVal < 16) {
                    buf.append('0');
                }
                buf.append(Integer.toHexString(intVal).toUpperCase());
            }
        }
        return buf == null ? s : buf.toString();
    }

    public static boolean shouldRenderAttribute(Object attributeVal) {
        if (null == attributeVal) {
            return false;
        }
        if (attributeVal instanceof Boolean && ((Boolean)attributeVal).booleanValue() == Boolean.FALSE.booleanValue()) {
            return false;
        }
        if (attributeVal.toString().length() == 0) {
            return false;
        }
        return ScriptUtils.isValidProperty(attributeVal);
    }

    public static boolean shouldRenderAttribute(String attributeName, Object attributeVal) {
        return ScriptUtils.shouldRenderAttribute(attributeVal);
    }

    public static boolean isValidProperty(Object property) {
        if (null == property) {
            return false;
        }
        if (property instanceof Integer && (Integer)property == Integer.MIN_VALUE) {
            return false;
        }
        if (property instanceof Double && (Double)property == Double.MIN_VALUE) {
            return false;
        }
        if (property instanceof Character && ((Character)property).charValue() == '\u0000') {
            return false;
        }
        if (property instanceof Float && ((Float)property).floatValue() == Float.MIN_VALUE) {
            return false;
        }
        if (property instanceof Short && (Short)property == Short.MIN_VALUE) {
            return false;
        }
        if (property instanceof Byte && (Byte)property == -128) {
            return false;
        }
        return !(property instanceof Long) || (Long)property != Long.MIN_VALUE;
    }

    public static String escapeCSSMetachars(String s) {
        int idx;
        if (s == null || s.length() == 0) {
            return s;
        }
        StringBuilder builder = new StringBuilder();
        int start = 0;
        int length = s.length();
        for (idx = 0; idx < length; ++idx) {
            char c = s.charAt(idx);
            int searchIdx = Arrays.binarySearch(CSS_SELECTOR_CHARS_TO_ESCAPE, c);
            if (searchIdx < 0) continue;
            builder.append(s.substring(start, idx));
            builder.append("\\");
            builder.append(c);
            start = idx + 1;
        }
        builder.append(s.substring(start, idx));
        return builder.toString();
    }
}

