/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.context;

import java.util.Collection;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import org.richfaces.context.ExtendedVisitContextMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExtendedVisitContext
extends VisitContext {
    public static final String META_COMPONENT_ID = "org.richfaces.MetaComponentId";
    private final FacesContext facesContext;
    private final ExtendedVisitContextMode visitMode;

    protected ExtendedVisitContext(FacesContext facesContext, ExtendedVisitContextMode visitMode) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        this.facesContext = facesContext;
        this.visitMode = visitMode;
    }

    public ExtendedVisitContextMode getVisitMode() {
        return this.visitMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VisitResult invokeMetaComponentVisitCallback(UIComponent component, VisitCallback callback, String metaComponentId) {
        if (metaComponentId != null) {
            Map attributes = this.getFacesContext().getAttributes();
            try {
                attributes.put(META_COMPONENT_ID, metaComponentId);
                VisitResult visitResult = this.invokeVisitCallback(component, callback);
                return visitResult;
            }
            finally {
                attributes.remove(META_COMPONENT_ID);
            }
        }
        return this.invokeVisitCallback(component, callback);
    }

    public String buildExtendedClientId(UIComponent component) {
        String extendedClientId = component.getClientId(this.facesContext);
        String subComponentId = (String)this.facesContext.getAttributes().get(META_COMPONENT_ID);
        if (subComponentId != null) {
            StringBuilder sb = new StringBuilder(extendedClientId.length() + 1 + subComponentId.length());
            sb.append(extendedClientId);
            sb.append('@');
            sb.append(subComponentId);
            extendedClientId = sb.toString();
        }
        return extendedClientId;
    }

    public String buildExtendedComponentId(UIComponent component) {
        String componentId = component.getId();
        String subComponentId = (String)this.facesContext.getAttributes().get(META_COMPONENT_ID);
        if (subComponentId != null) {
            StringBuilder sb = new StringBuilder(componentId.length() + 1 + subComponentId.length());
            sb.append(componentId);
            sb.append('@');
            sb.append(subComponentId);
            componentId = sb.toString();
        }
        return componentId;
    }

    public FacesContext getFacesContext() {
        return this.facesContext;
    }

    public abstract Collection<String> getDirectSubtreeIdsToVisit(UIComponent var1);

    public abstract VisitContext createNamingContainerVisitContext(UIComponent var1, Collection<String> var2);
}

