/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ImageType {
    GIF("gif"){

        public BufferedImage createImage(int width, int height) {
            return ImageType.createARGBImage(width, height);
        }
    }
    ,
    PNG("png"){

        public BufferedImage createImage(int width, int height) {
            return ImageType.createARGBImage(width, height);
        }
    }
    ,
    PNG8("png"){

        public BufferedImage createImage(int width, int height) {
            return new BufferedImage(width, height, 13, SAFE_WEB_COLORS_MODEL);
        }
    }
    ,
    JPEG("jpeg"){

        public BufferedImage createImage(int width, int height) {
            return new BufferedImage(width, height, 1);
        }
    };

    protected static final IndexColorModel SAFE_WEB_COLORS_MODEL;
    private String formatName;
    private String mimeType;

    private ImageType(String formatName) {
        this.formatName = formatName;
        this.mimeType = "image/" + formatName;
    }

    private static BufferedImage createARGBImage(int width, int height) {
        return new BufferedImage(width, height, 2);
    }

    public abstract BufferedImage createImage(int var1, int var2);

    public String getFormatName() {
        return this.formatName;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    static {
        byte[] webLevels = new byte[]{0, 51, 102, -103, -52, -1};
        int colorsNumber = webLevels.length * webLevels.length * webLevels.length;
        byte[] r = new byte[colorsNumber];
        byte[] g = new byte[colorsNumber];
        byte[] b = new byte[colorsNumber];
        r[0] = 0;
        g[0] = 0;
        b[0] = 0;
        for (int i = 0; i < webLevels.length; ++i) {
            for (int j = 0; j < webLevels.length; ++j) {
                for (int k = 0; k < webLevels.length; ++k) {
                    int colorNum = i * webLevels.length * webLevels.length + j * webLevels.length + k;
                    r[colorNum] = webLevels[i];
                    g[colorNum] = webLevels[j];
                    b[colorNum] = webLevels[k];
                }
            }
        }
        SAFE_WEB_COLORS_MODEL = new IndexColorModel(8, colorsNumber, r, g, b, 0);
    }
}

