/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces;

import java.util.logging.Level;
import org.richfaces.Logger;

public class JavaLogger
implements Logger {
    public static final String RICHFACES_LOG = "org.richfaces.cdk";
    private static final String DEFAULT_MESSAGE = "Exception";
    private final java.util.logging.Logger jdkLogger;

    JavaLogger(String category) {
        this.jdkLogger = java.util.logging.Logger.getLogger(category);
    }

    JavaLogger() {
        this(RICHFACES_LOG);
    }

    public void debug(CharSequence content) {
        this.jdkLogger.fine(String.valueOf(content));
    }

    public void debug(CharSequence content, Throwable error) {
        this.jdkLogger.log(Level.FINE, String.valueOf(content), error);
    }

    public void debug(Throwable error) {
        this.jdkLogger.log(Level.FINE, "", error);
    }

    public void error(CharSequence content) {
        this.jdkLogger.severe(String.valueOf(content));
    }

    public void error(CharSequence content, Throwable error) {
        this.jdkLogger.log(Level.SEVERE, String.valueOf(content), error);
    }

    public void error(Throwable error) {
        this.jdkLogger.log(Level.SEVERE, "", error);
    }

    public void info(CharSequence content) {
        this.jdkLogger.info(String.valueOf(content));
    }

    public void info(CharSequence content, Throwable error) {
        this.jdkLogger.log(Level.INFO, String.valueOf(content), error);
    }

    public void info(Throwable error) {
        this.jdkLogger.log(Level.INFO, "", error);
    }

    public boolean isDebugEnabled() {
        return this.jdkLogger.isLoggable(Level.FINE);
    }

    public boolean isErrorEnabled() {
        return this.jdkLogger.isLoggable(Level.SEVERE);
    }

    public boolean isInfoEnabled() {
        return this.jdkLogger.isLoggable(Level.INFO);
    }

    public boolean isWarnEnabled() {
        return this.jdkLogger.isLoggable(Level.WARNING);
    }

    public void warn(CharSequence content) {
        this.jdkLogger.warning(String.valueOf(content));
    }

    public void warn(CharSequence content, Throwable error) {
        this.jdkLogger.log(Level.WARNING, String.valueOf(content), error);
    }

    public void warn(Throwable error) {
        this.jdkLogger.log(Level.WARNING, "", error);
    }

    public boolean isLogEnabled(Logger.Level level) {
        return this.jdkLogger.isLoggable(this.toJavaLevel(level));
    }

    public void log(Logger.Level level, CharSequence content) {
        this.jdkLogger.log(this.toJavaLevel(level), String.valueOf(content));
    }

    public void log(Logger.Level level, CharSequence content, Throwable error) {
        this.jdkLogger.log(this.toJavaLevel(level), String.valueOf(content), error);
    }

    public void log(Logger.Level level, Throwable error) {
        this.jdkLogger.log(this.toJavaLevel(level), DEFAULT_MESSAGE, error);
    }

    private Level toJavaLevel(Logger.Level level) {
        switch (level) {
            case ERROR: {
                return Level.SEVERE;
            }
            case INFO: {
                return Level.INFO;
            }
            case WARNING: {
                return Level.WARNING;
            }
            case DEBUG: {
                return Level.FINE;
            }
        }
        throw new IllegalArgumentException("Logging level must be set to obtain a logger");
    }
}

