/*
 * JBoss, Home of Professional Open Source
 * Copyright , Red Hat, Inc. and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.richfaces.component;

import javax.annotation.Generated;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHelper;
import org.richfaces.PartialStateHolderHelper;
import org.richfaces.component.AbstractCommandButton;

/**
 *  @author Nick Belaevski


 **/
@Generated({"RichFaces CDK", "4.0.0-SNAPSHOT"})
public class UICommandButton extends AbstractCommandButton
    implements ClientBehaviorHolder
    {

    public static final String COMPONENT_TYPE="org.richfaces.CommandButton";

    public static final String COMPONENT_FAMILY="javax.faces.Command";

    @Override
    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public UICommandButton() {
        super();
        setRendererType("org.richfaces.CommandButtonRenderer");
    }

    private static final Collection<String> EVENT_NAMES = Collections.unmodifiableCollection(Arrays.asList(
        "keypress",
        "mousedown",
        "keyup",
        "dblclick",
        "click",
        "mouseover",
        "mousemove",
        "mouseout",
        "keydown",
        "action",
        "mouseup"

        ));
    
    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }


    public String getDefaultEventName() {
        return "action";
    }

    protected static enum Properties {
        bypassUpdates,
        limitRender,
        onclick,
        ondblclick,
        onkeydown,
        onkeypress,
        onkeyup,
        onmousedown,
        onmousemove,
        onmouseout,
        onmouseover,
        onmouseup,
        style,
        styleClass

    }


 
    public boolean isBypassUpdates() {
        return Boolean.valueOf(getStateHelper().eval(Properties.bypassUpdates, false).toString());
    }
    
    public void setBypassUpdates(boolean bypassUpdates) {
        getStateHelper().put(Properties.bypassUpdates, bypassUpdates);
    }

 
    public boolean isLimitRender() {
        return Boolean.valueOf(getStateHelper().eval(Properties.limitRender, false).toString());
    }
    
    public void setLimitRender(boolean limitRender) {
        getStateHelper().put(Properties.limitRender, limitRender);
    }

 
    public String getOnclick() {
        return (String) getStateHelper().eval(Properties.onclick);
    }
    
    public void setOnclick(String onclick) {
        getStateHelper().put(Properties.onclick, onclick);
    }

 
    public String getOndblclick() {
        return (String) getStateHelper().eval(Properties.ondblclick);
    }
    
    public void setOndblclick(String ondblclick) {
        getStateHelper().put(Properties.ondblclick, ondblclick);
    }

 
    public String getOnkeydown() {
        return (String) getStateHelper().eval(Properties.onkeydown);
    }
    
    public void setOnkeydown(String onkeydown) {
        getStateHelper().put(Properties.onkeydown, onkeydown);
    }

 
    public String getOnkeypress() {
        return (String) getStateHelper().eval(Properties.onkeypress);
    }
    
    public void setOnkeypress(String onkeypress) {
        getStateHelper().put(Properties.onkeypress, onkeypress);
    }

 
    public String getOnkeyup() {
        return (String) getStateHelper().eval(Properties.onkeyup);
    }
    
    public void setOnkeyup(String onkeyup) {
        getStateHelper().put(Properties.onkeyup, onkeyup);
    }

 
    public String getOnmousedown() {
        return (String) getStateHelper().eval(Properties.onmousedown);
    }
    
    public void setOnmousedown(String onmousedown) {
        getStateHelper().put(Properties.onmousedown, onmousedown);
    }

 
    public String getOnmousemove() {
        return (String) getStateHelper().eval(Properties.onmousemove);
    }
    
    public void setOnmousemove(String onmousemove) {
        getStateHelper().put(Properties.onmousemove, onmousemove);
    }

 
    public String getOnmouseout() {
        return (String) getStateHelper().eval(Properties.onmouseout);
    }
    
    public void setOnmouseout(String onmouseout) {
        getStateHelper().put(Properties.onmouseout, onmouseout);
    }

 
    public String getOnmouseover() {
        return (String) getStateHelper().eval(Properties.onmouseover);
    }
    
    public void setOnmouseover(String onmouseover) {
        getStateHelper().put(Properties.onmouseover, onmouseover);
    }

 
    public String getOnmouseup() {
        return (String) getStateHelper().eval(Properties.onmouseup);
    }
    
    public void setOnmouseup(String onmouseup) {
        getStateHelper().put(Properties.onmouseup, onmouseup);
    }

 
    public String getStyle() {
        return (String) getStateHelper().eval(Properties.style);
    }
    
    public void setStyle(String style) {
        getStateHelper().put(Properties.style, style);
    }

 
    public String getStyleClass() {
        return (String) getStateHelper().eval(Properties.styleClass);
    }
    
    public void setStyleClass(String styleClass) {
        getStateHelper().put(Properties.styleClass, styleClass);
    }

}